/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings.type;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeVisitor;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.data.ConstraintValidator;
import com.vmware.vapi.internal.util.Validate;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructType
implements Type {
    private static final Logger logger = LoggerFactory.getLogger(StructType.class);
    private final String name;
    private final String discriminatedBy;
    private final String discriminator;
    private final Map<String, Type> fields;
    private final Class<?> bindingClass;
    private final List<ConstraintValidator> validators;
    private final boolean isModel;
    private final List<String> modelKeyFields;
    private final Map<String, FieldInfo> fieldInfos;
    private final Iterable<String> fieldWithSetterNames;

    public StructType(String name, Map<String, Type> fields, Class<?> bindingClass, List<ConstraintValidator> validators, boolean isModel, List<String> modelKeyFields, Map<String, FieldNameDetails> fieldNameDetails) {
        this(name, fields, bindingClass, validators, isModel, modelKeyFields, fieldNameDetails, null, null);
    }

    public StructType(String name, Map<String, Type> fields, Class<?> bindingClass, List<ConstraintValidator> validators, boolean isModel, List<String> modelKeyFields, Map<String, FieldNameDetails> fieldNameDetails, String discriminator, String discriminatedBy) {
        Validate.notNull(name);
        Validate.notNull(fields);
        Validate.notNull(bindingClass);
        if (discriminatedBy != null && discriminator == null) {
            throw new IllegalArgumentException("Structure with discriminating value has no discriminator field");
        }
        if (discriminator != null && !fields.containsKey(discriminator)) {
            throw new IllegalArgumentException("No such field for discriminator: " + discriminator);
        }
        this.name = name;
        this.discriminatedBy = discriminatedBy;
        this.fields = Collections.unmodifiableMap(fields);
        this.discriminator = discriminator;
        this.bindingClass = bindingClass;
        this.isModel = isModel;
        this.modelKeyFields = modelKeyFields;
        this.validators = validators == null ? Collections.emptyList() : validators;
        Map<Object, Object> map = this.fieldInfos = fieldNameDetails == null ? Collections.emptyMap() : this.buildFieldInfoMap(fieldNameDetails);
        if (!this.fieldInfos.isEmpty()) {
            Validate.isTrue(this.fields.keySet().equals(this.fieldInfos.keySet()));
        }
        this.fieldWithSetterNames = this.getFieldsWithSetter(this.fieldInfos.values());
    }

    private Iterable<String> getFieldsWithSetter(Collection<FieldInfo> collection) {
        for (FieldInfo fieldInfo : collection) {
            if (fieldInfo.getNameDetails().getSetterName() != null) continue;
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new SetterAvailableIterator();
                }
            };
        }
        return this.fieldInfos.keySet();
    }

    private Map<String, FieldInfo> buildFieldInfoMap(Map<String, FieldNameDetails> fieldNameDetails) {
        Method[] methods = this.bindingClass.getMethods();
        HashMap<String, FieldInfo> result = new HashMap<String, FieldInfo>();
        for (Map.Entry<String, FieldNameDetails> entry : fieldNameDetails.entrySet()) {
            Method getter = this.findMethodForName(entry.getValue().getGetterName(), methods);
            this.logWarnIfMethodNotFound(getter, entry.getValue().getGetterName());
            Method setter = null;
            String setterName = entry.getValue().getSetterName();
            if (setterName != null) {
                setter = this.findMethodForName(setterName, methods);
                this.logWarnIfMethodNotFound(setter, setterName);
            }
            result.put(entry.getKey(), new FieldInfo(entry.getValue(), getter, setter));
        }
        return result;
    }

    private void logWarnIfMethodNotFound(Method method, String expectedMethodName) {
        if (method == null) {
            logger.warn("Could not reflectively find getter/setter method {} in class {}", (Object)expectedMethodName, (Object)this.bindingClass.getCanonicalName());
        }
    }

    private Method findMethodForName(String methodName, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            return methods[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public String getDiscriminatedBy() {
        return this.discriminatedBy;
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public Iterable<String> getFieldWithSetterNames() {
        return this.fieldWithSetterNames;
    }

    public Type getField(String field) {
        Validate.notNull(field);
        return this.fields.get(field);
    }

    public Type getFieldByJavaName(String javaName) {
        Validate.notNull(javaName);
        for (FieldInfo fieldInfo : this.fieldInfos.values()) {
            if (!fieldInfo.getNameDetails().getMixedCaseName().equals(javaName)) continue;
            return this.getField(fieldInfo.getNameDetails().getCanonicalName());
        }
        return null;
    }

    public List<String> getModelKeyFields() {
        if (this.modelKeyFields == null) {
            return null;
        }
        return Collections.unmodifiableList(this.modelKeyFields);
    }

    public Method getGetterMethodForField(String fieldName) {
        Validate.notNull(fieldName);
        FieldInfo fieldInfo = this.getFieldInfo(fieldName);
        if (fieldInfo.getGetterMethod() == null) {
            throw new ConverterException("vapi.bindings.structbinding.struct.missing.getter", fieldInfo.getNameDetails().getGetterName(), this.bindingClass.getClass().getCanonicalName());
        }
        return fieldInfo.getGetterMethod();
    }

    public Method getSetterMethodForField(String fieldName) {
        Validate.notNull(fieldName);
        FieldInfo fieldInfo = this.getFieldInfo(fieldName);
        if (fieldInfo.getSetterMethod() == null) {
            throw new ConverterException("vapi.bindings.structbinding.struct.missing.setter", fieldInfo.getNameDetails().getSetterName(), this.bindingClass.getCanonicalName());
        }
        return fieldInfo.getSetterMethod();
    }

    FieldInfo getFieldInfo(String fieldName) {
        FieldInfo fieldInfo = this.fieldInfos.get(fieldName);
        if (fieldInfo == null) {
            throw new ConverterException("vapi.bindings.structbinding.struct.missing.field.details", fieldName, this.bindingClass.getCanonicalName());
        }
        return fieldInfo;
    }

    public void validate(StructValue structValue) {
        Validate.notNull(structValue);
        for (ConstraintValidator validator : this.validators) {
            validator.validate(structValue);
        }
    }

    public void validate(StructValue structValue, MethodIdentifier methodId) {
        Validate.notNull(methodId);
        this.validate(structValue);
    }

    public Class<?> getBindingClass() {
        return this.bindingClass;
    }

    public boolean isModel() {
        return this.isModel;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    public FieldNameDetails getFieldNameDetails(String canonicalName) {
        FieldInfo fieldInfo = this.fieldInfos.get(canonicalName);
        if (fieldInfo == null) {
            return null;
        }
        return fieldInfo.getNameDetails();
    }

    private class SetterAvailableIterator
    implements Iterator<String> {
        private Map.Entry<String, FieldInfo> next;
        private final Iterator<Map.Entry<String, FieldInfo>> iterator;

        SetterAvailableIterator() {
            this.iterator = StructType.this.fieldInfos.entrySet().iterator();
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            String result = this.next.getKey();
            this.findNext();
            return result;
        }

        private void findNext() {
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (this.next.getValue().getNameDetails().getSetterName() == null) continue;
                return;
            }
            this.next = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class FieldInfo {
        private FieldNameDetails nameDetails;
        private Method getterMethod;
        private Method setterMethod;

        FieldInfo(FieldNameDetails nameDetails, Method getterMethod, Method setterMethod) {
            this.nameDetails = nameDetails;
            this.getterMethod = getterMethod;
            this.setterMethod = setterMethod;
        }

        FieldNameDetails getNameDetails() {
            return this.nameDetails;
        }

        Method getGetterMethod() {
            return this.getterMethod;
        }

        Method getSetterMethod() {
            return this.setterMethod;
        }
    }

    public static class FieldNameDetails {
        private final String canonicalName;
        private final String mixedCaseName;
        private final String getterName;
        private final String setterName;

        public FieldNameDetails(String canonicalName, String mixedCaseName, String getterName, String setterName) {
            Validate.notEmpty(canonicalName);
            Validate.notEmpty(mixedCaseName);
            Validate.notEmpty(getterName);
            this.canonicalName = canonicalName;
            this.mixedCaseName = mixedCaseName;
            this.getterName = getterName;
            this.setterName = setterName;
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public String getMixedCaseName() {
            return this.mixedCaseName;
        }

        public String getGetterName() {
            return this.getterName;
        }

        public String getSetterName() {
            return this.setterName;
        }
    }
}

