/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.internal.util.Validate;

public class MethodIdentifier {
    private static final String METHOD_NAME_DELIMITER = ".";
    private final InterfaceIdentifier iface;
    private final String method;

    public MethodIdentifier(String path) {
        Validate.notNull(path);
        int index = path.lastIndexOf(METHOD_NAME_DELIMITER);
        if (index == 0) {
            this.iface = new InterfaceIdentifier("");
            this.method = "";
        } else if (index > 0) {
            this.iface = new InterfaceIdentifier(path.substring(0, index));
            this.method = path.substring(index + 1);
        } else {
            this.iface = new InterfaceIdentifier("");
            this.method = path;
        }
    }

    public MethodIdentifier(InterfaceIdentifier iface, String method) {
        Validate.notNull(iface);
        Validate.notNull(method);
        this.iface = iface;
        this.method = method;
    }

    public String getName() {
        return this.method;
    }

    public InterfaceIdentifier getInterfaceIdentifier() {
        return this.iface;
    }

    public String getFullyQualifiedName() {
        return MethodIdentifier.getFullyQualifiedName(this.iface.getName(), this.method);
    }

    public static String getFullyQualifiedName(String iface, String method) {
        return iface + METHOD_NAME_DELIMITER + method;
    }

    public boolean equals(Object o) {
        if (o instanceof MethodIdentifier) {
            MethodIdentifier tmp = (MethodIdentifier)o;
            return this.method.equals(tmp.method) && this.iface.equals(tmp.iface);
        }
        return false;
    }

    public int hashCode() {
        return this.iface.hashCode() + this.method.hashCode();
    }

    public String toString() {
        return this.iface + METHOD_NAME_DELIMITER + this.method;
    }
}

