/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DefinitionVisitor;
import com.vmware.vapi.data.OptionalDefinition;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.util.Validate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructDefinition
extends DataDefinition {
    static Logger logger = LoggerFactory.getLogger(StructDefinition.class);
    private final Map<String, DataDefinition> fields;
    private final String name;

    public StructDefinition(String name, Map<String, DataDefinition> fields) {
        Validate.notNull(name);
        Validate.notNull(fields);
        this.name = name;
        for (Map.Entry<String, DataDefinition> field : fields.entrySet()) {
            if (field.getValue() != null) continue;
            throw new IllegalArgumentException("Missing definition for field " + field.getKey());
        }
        this.fields = new HashMap<String, DataDefinition>(fields);
    }

    @Override
    public DataType getType() {
        return DataType.STRUCTURE;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public DataDefinition getField(String field) {
        return this.fields.get(field);
    }

    public boolean hasField(String field) {
        return this.fields.containsKey(field);
    }

    public StructValue newInstance() {
        return new StructValue(this.getName());
    }

    @Override
    public List<Message> validate(DataValue value) {
        List<Message> errors = super.validate(value);
        if (!errors.isEmpty()) {
            return errors;
        }
        StructValue str = (StructValue)value;
        if (!this.getName().equals(str.getName())) {
            errors.add(MessageFactory.getMessage("vapi.data.structure.name.mismatch", this.getName(), str.getName()));
            return errors;
        }
        for (String fieldName : this.fields.keySet()) {
            if (!str.hasField(fieldName)) {
                errors.add(MessageFactory.getMessage("vapi.data.structure.field.missing", this.getName(), fieldName));
            } else {
                List<Object> subErrors;
                DataDefinition fieldDef = this.fields.get(fieldName);
                try {
                    DataValue fieldVal = str.getField(fieldName);
                    subErrors = fieldDef.validate(fieldVal);
                }
                catch (CoreException ex) {
                    subErrors = new LinkedList<Message>();
                    subErrors.addAll(ex.getExceptionMessages());
                }
                if (!subErrors.isEmpty()) {
                    errors.add(MessageFactory.getMessage("vapi.data.structure.field.invalid", fieldName));
                    errors.addAll(subErrors);
                }
            }
            if (errors.isEmpty()) continue;
            break;
        }
        return errors;
    }

    @Override
    public void completeValue(DataValue value) {
        if (value != null && value.getType() == this.getType()) {
            StructValue str = (StructValue)value;
            for (String fieldName : this.fields.keySet()) {
                if (!str.hasField(fieldName)) {
                    DataDefinition fieldDef = this.fields.get(fieldName);
                    if (fieldDef.getType() != DataType.OPTIONAL) continue;
                    OptionalDefinition optDef = (OptionalDefinition)fieldDef;
                    try {
                        str.setField(fieldName, optDef.newInstance());
                    }
                    catch (CoreException ex) {
                        logger.debug("Unable to fill in optional value for " + fieldName, (Throwable)ex);
                    }
                    continue;
                }
                DataDefinition subElement = this.fields.get(fieldName);
                subElement.completeValue(str.getField(fieldName));
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructDefinition)) {
            return false;
        }
        StructDefinition otherStruct = (StructDefinition)other;
        return this.name.equals(otherStruct.name) && this.fields.equals(otherStruct.fields);
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * this.name.hashCode();
        return hash += 31 * this.fields.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName() + " {");
        for (Map.Entry<String, DataDefinition> e : this.fields.entrySet()) {
            buf.append("'");
            buf.append(e.getKey());
            buf.append("' : ");
            buf.append(e.getValue());
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}

