/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.bindings.client.AsyncCallbackSyncAdapter;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.bindings.type.AnyErrorType;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.Consumer;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.diagnostics.LogDiagnosticUtil;
import com.vmware.vapi.diagnostics.Slf4jMDCLogConfigurator;
import com.vmware.vapi.internal.bindings.BindingsExceptionTranslator;
import com.vmware.vapi.internal.bindings.ProgressConverter;
import com.vmware.vapi.internal.bindings.ResultTranslatingHandle;
import com.vmware.vapi.internal.bindings.RetryingHandle;
import com.vmware.vapi.internal.bindings.StreamPublisher;
import com.vmware.vapi.internal.bindings.StructValueBuilder;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.bindings.ValidatorUtil;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.DefaultConverterFactory;
import com.vmware.vapi.internal.bindings.convert.impl.JavaClassStructConverter;
import com.vmware.vapi.internal.bindings.convert.impl.MapBasedNameToTypeResolver;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.std.Progress;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stub {
    private static final Logger LOGGER = LoggerFactory.getLogger(Stub.class);
    protected final InterfaceIdentifier ifaceId;
    protected final ApiProvider apiProvider;
    protected final TypeConverter converter;
    protected final ExecutionContext.SecurityContext securityContext;
    protected final RetryPolicy retryPolicy;

    protected Stub(ApiProvider apiProvider, InterfaceIdentifier ifaceId, StubConfigurationBase config) {
        this(apiProvider, null, ifaceId, config);
    }

    protected Stub(ApiProvider apiProvider, TypeConverter typeConverter, InterfaceIdentifier ifaceId, StubConfigurationBase config) {
        Validate.notNull(apiProvider);
        Validate.notNull(config);
        Validate.notNull(ifaceId);
        this.ifaceId = ifaceId;
        this.apiProvider = apiProvider;
        this.converter = typeConverter != null ? typeConverter : Stub.createTypeConverter(config.getErrorTypes());
        this.securityContext = config.getSecurityContext();
        this.retryPolicy = config.getRetryPolicy();
    }

    protected <T> T invokeMethod(MethodIdentifier methodId, StructValueBuilder structBuilder, StructType inputType, Type outputType, Collection<Type> errorTypes, InvocationConfig invocationConfig) {
        AsyncCallbackSyncAdapter future = new AsyncCallbackSyncAdapter();
        this.invokeMethodAsync(methodId, structBuilder, inputType, outputType, errorTypes, invocationConfig, future);
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }

    protected <T> void invokeMethodAsync(MethodIdentifier methodId, StructValueBuilder structBuilder, StructType inputType, Type outputType, Collection<Type> errorTypes, InvocationConfig invocationConfig, final AsyncCallback<T> asyncCallback) {
        StructValue inputValue;
        try {
            inputValue = structBuilder.getStructValue();
            this.validateInput(inputType, inputValue, methodId);
        }
        catch (RuntimeException e) {
            asyncCallback.onError(BindingsExceptionTranslator.translate(e));
            return;
        }
        ExecutionContext execCtx = this.getExecutionContext(invocationConfig);
        ResultTranslatingHandle handle = new ResultTranslatingHandle<T>(this, outputType, errorTypes){

            @Override
            public void updateProgress(DataValue progress) {
                asyncCallback.onProgress(Stub.this.convertProgress(progress));
            }

            @Override
            public void onSuccess(T result, Consumer<AsyncHandle<MethodResult>> next) {
                asyncCallback.onResult(result);
            }

            @Override
            public void onFailure(RuntimeException error) {
                asyncCallback.onError(error);
            }
        };
        String serviceId = methodId.getInterfaceIdentifier().getName();
        String operationId = methodId.getName();
        this.invoke(handle, serviceId, operationId, inputValue, outputType, errorTypes, execCtx, asyncCallback, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void invoke(final ResultTranslatingHandle<T> handle, final String serviceId, final String operationId, final StructValue inputValue, Type outputType, Collection<Type> errorTypes, ExecutionContext executionContext, final AsyncCallback<T> asyncCallback, final int invocationAttempt) {
        RetryingHandle ah = handle;
        if (this.isRetryingConfigured()) {
            ah = new RetryingHandle<T>(this, outputType, errorTypes, handle, serviceId, operationId, executionContext, inputValue, invocationAttempt){

                @Override
                void onRetry(ExecutionContext retryContext) {
                    Stub.this.invoke(handle, serviceId, operationId, inputValue, this.outputType, this.errorTypes, retryContext, asyncCallback, invocationAttempt + 1);
                }
            };
        }
        Slf4jMDCLogConfigurator logConfig = new Slf4jMDCLogConfigurator();
        try {
            logConfig.configureContext(LogDiagnosticUtil.getDiagnosticContext(executionContext));
            this.apiProvider.invoke(serviceId, operationId, inputValue, executionContext, ah);
        }
        finally {
            logConfig.cleanUpContext(LogDiagnosticUtil.getDiagnosticKeys());
        }
    }

    void validateInput(StructType inputType, StructValue inputValue, MethodIdentifier methodId) {
        ValidatorUtil.validate(inputType, inputValue, methodId);
    }

    protected <T> Object invokeStreamMethod(MethodIdentifier methodId, StructValueBuilder structBuilder, StructType inputType, Type outputType, Collection<Type> errorTypes, InvocationConfig invocationConfig) {
        StructValue inputValue;
        try {
            inputValue = structBuilder.getStructValue();
            this.validateInput(inputType, inputValue, methodId);
        }
        catch (RuntimeException e) {
            throw BindingsExceptionTranslator.translate(e);
        }
        return new StreamPublisher(this, methodId, inputValue, inputType, outputType, errorTypes, invocationConfig);
    }

    ErrorType resolveErrorType(ErrorValue errValue, Collection<Type> errorTypes) {
        if (errValue == null) {
            return null;
        }
        String errorValueName = errValue.getName();
        if (errorTypes != null) {
            for (Type t : errorTypes) {
                ErrorType errType = (ErrorType)((TypeReference)t).resolve();
                if (!errorValueName.equals(errType.getName())) continue;
                return errType;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "<" + this.ifaceId.getName() + ">";
    }

    private static ExecutionContext getExecutionContextForRetry(ExecutionContext oldContext, RetryPolicy.RetrySpec retrySpec) {
        String opId;
        if (retrySpec.getInvocationConfig() == null) {
            return oldContext;
        }
        InvocationConfig invocationConfig = retrySpec.getInvocationConfig();
        ExecutionContext newContext = invocationConfig.getExecutionContext();
        if (newContext == null) {
            return oldContext;
        }
        ExecutionContext.ApplicationData newData = newContext.retrieveApplicationData();
        ExecutionContext.ApplicationData oldData = oldContext.retrieveApplicationData();
        if (newData == null) {
            newData = oldData;
        } else if (Stub.getOpId(newData) == null && (opId = Stub.getOpId(oldData)) != null) {
            newData = ExecutionContext.ApplicationData.merge(newData, "opId", opId);
        }
        ExecutionContext.SecurityContext newSecurity = newContext.retrieveSecurityContext();
        if (newSecurity == null) {
            newSecurity = oldContext.retrieveSecurityContext();
        }
        return new ExecutionContext(newData, newSecurity, newContext.retrieveRuntimeData());
    }

    ExecutionContext getExecutionContext(InvocationConfig invocationConfig) {
        return new ExecutionContext(Stub.getApplicationData(invocationConfig), this.getSecurityContext(invocationConfig), this.getRuntimeData(invocationConfig));
    }

    private ExecutionContext.SecurityContext getSecurityContext(InvocationConfig invocationConfig) {
        if (invocationConfig != null && invocationConfig.getExecutionContext() != null && invocationConfig.getExecutionContext().retrieveSecurityContext() != null) {
            return invocationConfig.getExecutionContext().retrieveSecurityContext();
        }
        return this.securityContext;
    }

    private static ExecutionContext.ApplicationData getApplicationData(InvocationConfig ic) {
        ExecutionContext.ApplicationData ad;
        ExecutionContext ec;
        if (ic != null && (ec = ic.getExecutionContext()) != null && (ad = ec.retrieveApplicationData()) != null) {
            if (ad.getAllProperties().containsKey("opId")) {
                return ad;
            }
            return ExecutionContext.ApplicationData.merge(ad, "opId", Stub.generateNewOpId());
        }
        return new ExecutionContext.ApplicationData("opId", Stub.generateNewOpId());
    }

    private static String generateNewOpId() {
        return UUID.randomUUID().toString();
    }

    private ExecutionContext.RuntimeData getRuntimeData(InvocationConfig invocationConfig) {
        if (invocationConfig == null) {
            return null;
        }
        ExecutionContext executionContext = invocationConfig.getExecutionContext();
        if (executionContext == null) {
            return null;
        }
        return executionContext.retrieveRuntimeData();
    }

    private static String getOpId(ExecutionContext.ApplicationData data) {
        if (data == null) {
            return null;
        }
        return data.getProperty("opId");
    }

    <T> T convert(DataValue value, Type type) {
        try {
            return this.converter.convertToJava(value, type);
        }
        catch (RuntimeException e) {
            throw BindingsExceptionTranslator.translate(e);
        }
    }

    private Progress convertProgress(DataValue progressValue) {
        return ProgressConverter.fromValue(progressValue);
    }

    RuntimeException convertError(ErrorValue error, Collection<Type> errorTypes) {
        Type type = this.resolveErrorType(error, errorTypes);
        if (type == null) {
            type = new AnyErrorType();
        }
        return (RuntimeException)this.convert(error, type);
    }

    private static TypeConverter createTypeConverter(Set<ErrorType> typeSet) {
        Map<String, StructType> errorTypes = MapBasedNameToTypeResolver.augmentWithStandardErrors(typeSet);
        MapBasedNameToTypeResolver errorsResolver = new MapBasedNameToTypeResolver(errorTypes);
        return new TypeConverterImpl(new StubConverterFactory(errorsResolver));
    }

    ExecutionContext getRetryContext(String serviceId, String operationId, ExecutionContext executionContext, StructValue inputValue, RuntimeException error, int invocationAttempt) {
        RetryPolicy.RetrySpec retrySpec;
        block3: {
            RetryPolicy.RetryContext context = new RetryPolicy.RetryContext(serviceId, operationId, executionContext, inputValue);
            retrySpec = null;
            try {
                retrySpec = this.retryPolicy.onInvocationError(error, context, invocationAttempt);
            }
            catch (RuntimeException e) {
                if (!LOGGER.isWarnEnabled()) break block3;
                String message = String.format("onInvocationError call on %s for %s.%s failed", retrySpec, serviceId, operationId);
                LOGGER.warn(message, (Throwable)e);
            }
        }
        if (retrySpec == null) {
            return null;
        }
        return Stub.getExecutionContextForRetry(executionContext, retrySpec);
    }

    boolean isRetryingConfigured() {
        return this.retryPolicy != null;
    }

    static final class StubConverterFactory
    extends DefaultConverterFactory {
        private final UniTypeConverter<StructValue, StructType> skipUnsetStructConverter = new JavaClassStructConverter<StructValue, StructType>(StructValue.class, Structure.class, true);

        StubConverterFactory(NameToTypeResolver nameToTypeResolver) {
            super(nameToTypeResolver);
        }

        @Override
        public UniTypeConverter<StructValue, StructType> getStructConverter() {
            return this.skipUnsetStructConverter;
        }
    }
}

