/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.internal.protocol.client.rpc.RestTransport;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientRequestConfigurationMerger;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientRestTransport;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpResponse;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.ConnectionMonitor;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.protocol.HttpContext;

public class ApacheAsyncClientRestTransport
implements RestTransport {
    private final CloseableHttpAsyncClient httpClient;
    private final ApacheClientRequestConfigurationMerger configMerger;
    private final ConnectionMonitor.CleanableConnectionPool connectionPool;

    public ApacheAsyncClientRestTransport(CloseableHttpAsyncClient httpClient, RequestConfig defaultRequestConfig) {
        this(httpClient, defaultRequestConfig, null);
    }

    public ApacheAsyncClientRestTransport(CloseableHttpAsyncClient httpClient, RequestConfig defaultRequestConfig, ConnectionMonitor.CleanableConnectionPool connectionPool) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.configMerger = new ApacheClientRequestConfigurationMerger(defaultRequestConfig);
        this.connectionPool = connectionPool;
    }

    @Override
    public void execute(HttpRequest request, HttpRequest.HttpResponseHandler responseHandler, ExecutionContext ctx) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(request.getUrl());
        Objects.requireNonNull(request.getMethod());
        Objects.requireNonNull(responseHandler);
        Objects.requireNonNull(ctx);
        HttpUriRequest apacheRequest = ApacheClientRestTransport.createRequest(request);
        ApacheClientRestTransport.addRequestHeaders(request, apacheRequest);
        ApacheClientRestTransport.addRequestBody(request, apacheRequest);
        HttpClientContext context = ApacheHttpUtil.createHttpContext(request.getReadTimeout(), this.configMerger);
        this.httpClient.execute(apacheRequest, (HttpContext)context, (FutureCallback)new ResponseCallback(responseHandler, ctx));
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private static final class ResponseCallback
    implements FutureCallback<HttpResponse> {
        private final HttpRequest.HttpResponseHandler responseHandler;
        private final ExecutionContext ctx;

        private ResponseCallback(HttpRequest.HttpResponseHandler responseHandler, ExecutionContext ctx) {
            this.responseHandler = responseHandler;
            this.ctx = ctx;
        }

        public void completed(HttpResponse apacheResponse) {
            ApacheHttpResponse response = new ApacheHttpResponse(apacheResponse);
            ApacheClientRestTransport.handleResponseAccessors(response, this.ctx);
            try {
                this.responseHandler.onResult(response);
            }
            catch (RuntimeException e) {
                this.failed(e);
            }
        }

        public void failed(Exception ex) {
            this.responseHandler.onError(ApacheHttpClientExceptionTranslator.translate(ex, null));
        }

        public void cancelled() {
            this.failed(new CancellationException());
        }
    }
}

