/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.NioDecoratorConsumer;
import com.vmware.vapi.internal.protocol.common.Util;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import java.util.Collection;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioSingleResponseConsumer
extends NioDecoratorConsumer {
    private final CorrelatingClient.ResponseCallback callback;
    private final Collection<String> acceptTypes;
    private final AbortHandle abortHandle;
    private static Logger logger = LoggerFactory.getLogger(NioSingleResponseConsumer.class);

    public NioSingleResponseConsumer(CorrelatingClient.ResponseCallback callback, Collection<String> acceptTypes, AbortHandle abortHandle) {
        this.callback = callback;
        this.decorated = new BasicAsyncResponseConsumer();
        this.acceptTypes = acceptTypes;
        this.abortHandle = abortHandle;
    }

    @Override
    public void responseCompleted(HttpContext context) {
        super.responseCompleted(context);
        HttpResponse httpResponse = super.getResult();
        if (Util.checkRequestAborted(this.abortHandle, this.callback)) {
            return;
        }
        try {
            ApacheHttpUtil.validateHttpResponse(httpResponse, this.acceptTypes);
            this.callback.received(httpResponse.getEntity().getContent(), CorrelatingClient.NO_OP_CONTROL);
        }
        catch (Exception ex) {
            logger.debug("Problem with HTTP response", (Throwable)ex);
            this.callback.failed(ApacheHttpClientExceptionTranslator.translate(ex, this.abortHandle));
        }
    }
}

