/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.protocol.common.json.JsonDataValueDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidDataValueException;
import java.io.IOException;

public class DefaultDataValueDeserializer
implements JsonDataValueDeserializer {
    @Override
    public DataValue deserializeDataValue(JsonParser jp) throws IOException {
        return DefaultDataValueDeserializer.deserializeDV(jp);
    }

    @Override
    public ErrorValue deserializeErrorValue(JsonParser jp) throws IOException {
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.FIELD_NAME);
        return DefaultDataValueDeserializer.deserializeEV(jp);
    }

    public static DataValue deserializeDV(JsonParser jp) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            return DefaultDataValueDeserializer.deserializeListValue(jp);
        }
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            jp.nextToken();
        }
        if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
            String dataType = jp.getCurrentName();
            if (dataType.equals(DataType.STRUCTURE.getValue())) {
                return DefaultDataValueDeserializer.deserializeStructValue(jp);
            }
            if (dataType.equals(DataType.OPTIONAL.getValue())) {
                return DefaultDataValueDeserializer.deserializeOptionalValue(jp);
            }
            if (dataType.equals(DataType.SECRET.getValue())) {
                return DefaultDataValueDeserializer.deserializeSecretValue(jp);
            }
            if (dataType.equals(DataType.BLOB.getValue())) {
                return DefaultDataValueDeserializer.deserializeBinaryValue(jp);
            }
            if (dataType.equals(DataType.ERROR.getValue())) {
                return DefaultDataValueDeserializer.deserializeEV(jp);
            }
            throw new JsonInvalidDataValueException("Unexpected JSON field detected: " + dataType);
        }
        return DefaultDataValueDeserializer.deserializePrimitiveValue(jp);
    }

    static StructValue deserializeStructValue(JsonParser jp) throws JsonParseException, IOException {
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.START_OBJECT);
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.FIELD_NAME);
        StructValue sv = new StructValue(jp.getCurrentName());
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.START_OBJECT);
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            sv.setField(fieldName, DefaultDataValueDeserializer.deserializeDV(jp));
        }
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.END_OBJECT);
        jp.nextToken();
        return sv;
    }

    static ListValue deserializeListValue(JsonParser jp) throws JsonParseException, IOException {
        ListValue lv = new ListValue();
        jp.nextToken();
        while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT || jp.getCurrentToken() == JsonToken.START_ARRAY) {
                lv.add(DefaultDataValueDeserializer.deserializeDV(jp));
                continue;
            }
            lv.add(DefaultDataValueDeserializer.deserializePrimitiveValue(jp));
        }
        jp.nextToken();
        return lv;
    }

    static DataValue deserializePrimitiveValue(JsonParser jp) throws IOException {
        try {
            BooleanValue dv = null;
            dv = jp.getBooleanValue() ? BooleanValue.TRUE : BooleanValue.FALSE;
            jp.nextToken();
            return dv;
        }
        catch (JsonParseException jpEx) {
            if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                jp.nextValue();
            }
            JsonToken curr = jp.getCurrentToken();
            DataValue dv = null;
            dv = curr == JsonToken.VALUE_NUMBER_INT ? new IntegerValue(jp.getLongValue()) : (curr == JsonToken.VALUE_NUMBER_FLOAT ? new DoubleValue(jp.getDoubleValue()) : (curr == JsonToken.VALUE_NULL ? VoidValue.getInstance() : new StringValue(jp.getText())));
            jp.nextToken();
            return dv;
        }
    }

    static OptionalValue deserializeOptionalValue(JsonParser jp) throws JsonParseException, IOException {
        if (jp.nextToken() == JsonToken.VALUE_NULL) {
            DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.END_OBJECT);
            jp.nextToken();
            return OptionalValue.UNSET;
        }
        OptionalValue result = new OptionalValue(DefaultDataValueDeserializer.deserializeDV(jp));
        jp.nextToken();
        return result;
    }

    static SecretValue deserializeSecretValue(JsonParser jp) throws JsonParseException, IOException {
        jp.nextToken();
        String text = jp.getText();
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.END_OBJECT);
        jp.nextToken();
        return new SecretValue(text.toCharArray());
    }

    static BlobValue deserializeBinaryValue(JsonParser jp) throws JsonParseException, IOException {
        jp.nextToken();
        byte[] bytes = jp.getBinaryValue();
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.END_OBJECT);
        jp.nextToken();
        return new BlobValue(bytes);
    }

    static ErrorValue deserializeEV(JsonParser jp) throws JsonParseException, IOException {
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.START_OBJECT);
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.FIELD_NAME);
        ErrorValue val = new ErrorValue(jp.getText());
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.START_OBJECT);
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            val.setField(fieldName, DefaultDataValueDeserializer.deserializeDV(jp));
        }
        DefaultDataValueDeserializer.nextExpectedToken(jp, JsonToken.END_OBJECT);
        jp.nextToken();
        return val;
    }

    static void nextExpectedToken(JsonParser jp, JsonToken expected) throws JsonParseException, IOException {
        if (jp.nextToken() != expected) {
            throw new JsonInvalidDataValueException(String.format("Expected %s JSON token but detected %s", expected, jp.getCurrentToken()));
        }
    }
}

