/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.security.AuthenticationHandler;
import com.vmware.vapi.security.PrincipalId;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationUtil.class);

    public AuthenticationHandler.AuthenticationResult retrieveAuthnResult(ExecutionContext ctx) {
        ExecutionContext.SecurityContext secCtx = ctx.retrieveSecurityContext();
        if (secCtx == null) {
            logger.debug("No SecurityContext found");
            return null;
        }
        return (AuthenticationHandler.AuthenticationResult)secCtx.getProperty("authn_data_id");
    }

    public String retrieveUserName(AuthenticationHandler.AuthenticationResult authnResult) {
        PrincipalId userId = authnResult.getUser();
        if (userId == null) {
            return null;
        }
        if (userId.getDomain() != null) {
            logger.debug("User name {}, domain {} ", (Object)userId.getName(), (Object)userId.getDomain());
            return userId.getDomain() + "\\" + userId.getName();
        }
        logger.debug("User name {}", (Object)userId.getName());
        return userId.getName();
    }

    public Set<String> retrieveUserGroups(AuthenticationHandler.AuthenticationResult authnResult) {
        List<PrincipalId> groupIds = authnResult.getGroups();
        HashSet<String> groupNames = new HashSet<String>();
        if (groupIds != null) {
            for (PrincipalId groupId : groupIds) {
                String groupName = groupId.getDomain() != null ? groupId.getDomain() + "\\" + groupId.getName() : groupId.getName();
                groupNames.add(groupName);
            }
        }
        logger.debug("Group names {}", groupNames);
        return groupNames;
    }
}

