/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol.client.http;

import com.vmware.vapi.core.HttpResponse;
import com.vmware.vapi.core.HttpResponseAccessor;
import com.vmware.vapi.internal.util.Validate;
import java.util.Arrays;
import java.util.List;

public class CompositeResponseAccessor
implements HttpResponseAccessor {
    private final List<HttpResponseAccessor> accessors;

    public CompositeResponseAccessor(List<HttpResponseAccessor> accessors) {
        Validate.noNullElements(accessors);
        this.accessors = accessors;
    }

    public CompositeResponseAccessor(HttpResponseAccessor ... accessors) {
        Validate.noNullElements(accessors);
        this.accessors = Arrays.asList(accessors);
    }

    @Override
    public void access(HttpResponse response) {
        for (HttpResponseAccessor acc : this.accessors) {
            acc.access(response);
        }
    }
}

