/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std.activation.impl;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.activation.ActivationMonitor;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.internal.std.activation.impl.ActivationRegistry;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vapi.std.activation.ActivationManagerProvider;
import com.vmware.vapi.std.errors.NotFound;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ActivationManagerImpl
extends ActivationMonitor
implements ActivationManagerProvider,
ActivationRegistry {
    private final ConcurrentMap<String, ActivationEntry> activations = new ConcurrentHashMap<String, ActivationEntry>();

    @Override
    public void register(String activationId, MethodIdentifier methodId) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull(activationId);
        Validate.notNull(methodId);
        ActivationEntry entry = new ActivationEntry();
        ActivationEntry old = this.activations.putIfAbsent(activationId, entry);
        if (old != null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void unregister(String activationId) throws IllegalArgumentException {
        Validate.notNull(activationId);
        this.activations.remove(activationId);
    }

    @Override
    public boolean isCancelRequested(String activationId) {
        if (activationId == null) {
            return false;
        }
        ActivationEntry entry = (ActivationEntry)this.activations.get(activationId);
        if (entry == null) {
            return false;
        }
        return entry.isCanceled();
    }

    @Override
    public void cancel(String activationId, AsyncContext<Void> asyncContext) {
        ActivationEntry entry = this.getEntry(activationId);
        entry.cancel();
        asyncContext.setResult(null);
    }

    private ActivationEntry getEntry(String activationId) throws NotFound {
        Validate.notNull(activationId);
        ActivationEntry entry = (ActivationEntry)this.activations.get(activationId);
        Message msg = MessageFactory.getMessage("vapi.activation.id.not.found", activationId);
        LocalizableMessage locMsg = new LocalizableMessage(msg.getId(), msg.getDefaultMessage(), Arrays.asList(msg.getArgs()));
        if (entry == null) {
            throw new NotFound(Collections.singletonList(locMsg), null);
        }
        return entry;
    }

    private static final class ActivationEntry {
        private volatile boolean canceled = false;

        private ActivationEntry() {
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

