/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.client.view.availability;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.vc.VcServersView;
import com.vmware.srm.client.topology.impl.utils.L10N;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public interface ExtensionServersView
extends VcServersView {
    @Override
    public <T extends Server<?>> Promise<T> getServerBy(String var1);

    default public Stream<ExtensionServer<?>> getServersFor(String vcGuid) {
        return Streams.from((Publisher[])new Publisher[]{this.getVcBy(vcGuid)}).flatMap(vc -> {
            Stream<Server<?>> servers = this.getAllServers();
            if (vc.isLocal()) {
                servers = this.getLocalServers();
            }
            return servers.filter(srv -> srv instanceof ExtensionServer).filter(ext -> ((ExtensionServer)ext).vc() == vc).map(srv -> (ExtensionServer)srv);
        });
    }

    public static class ServerByPairSetupException
    extends Topology.TopologyException {
        private final String _serverGuid;
        private final Map<PairSetup<?>, Exception> _pairSetupByCause;

        public ServerByPairSetupException(String serverGuid, Map<PairSetup<?>, Exception> pairSetupByCause) {
            super(L10N.localize("serverForGuidFailed", serverGuid));
            this._serverGuid = serverGuid;
            this._pairSetupByCause = new HashMap(pairSetupByCause);
        }

        public String getServerGuid() {
            return this._serverGuid;
        }

        public Set<PairSetup<?>> getPairSetups() {
            return Collections.unmodifiableSet(this._pairSetupByCause.keySet());
        }

        public Exception getCause(PairSetup<?> ps) {
            return this._pairSetupByCause.get(ps);
        }
    }
}

