/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    private static final Logger LOGGER;
    private static final String BCFIPS_PROVIDER_NAME = "BCFIPS";
    private static final long CERT_VALIDITY_RANGE_START_MILLISECS = 31536000000L;
    private static final long CERT_VALIDITY_RANGE_END_MILLISECS = 157680000000L;
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 2048;
    private static final String SIGNATURE_ALGORITHM = "SHA256WithRSAEncryption";
    private static final String THUMBPRINT_ALGORITHM = "SHA-256";
    private static final String ISSUER = "C=US, O=VMware vSphere Client, OU=Site Recovery Manager client";
    private static final String BEGIN_CERT_MARKER = "-----BEGIN CERTIFICATE-----\n";
    private static final String END_CERT_MARKER = "\n-----END CERTIFICATE-----\n";
    private static final CertificateFactory FACTORY;

    public static KeyPair generateKeyPair() {
        return CertificateUtils.getNewGenerator().generateKeyPair();
    }

    public static X509Certificate generateSelfSignedCert(KeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("keyPair");
        }
        long now = System.currentTimeMillis();
        JcaX509v1CertificateBuilder v1CertBldr = new JcaX509v1CertificateBuilder(new X500Name(ISSUER), BigInteger.valueOf(System.currentTimeMillis()), new Date(now - 31536000000L), new Date(now + 157680000000L), new X500Name(ISSUER), keyPair.getPublic());
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(BCFIPS_PROVIDER_NAME);
        try {
            return new JcaX509CertificateConverter().setProvider(BCFIPS_PROVIDER_NAME).getCertificate(v1CertBldr.build(signerBuilder.build(keyPair.getPrivate())));
        }
        catch (Exception e) {
            LOGGER.error("Certificate generation failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static KeyStore createTrustStore() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        return trustStore;
    }

    public static KeyStore createTrustStore(Collection<X509Certificate> certs) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        KeyStore store = CertificateUtils.createTrustStore();
        AliasGen gen = new AliasGen();
        for (X509Certificate cert : certs) {
            store.setCertificateEntry(gen.next(), cert);
        }
        return store;
    }

    public static <T extends Certificate> T getCertificate(String content) throws CertificateException, UnsupportedEncodingException {
        ByteArrayInputStream is = new ByteArrayInputStream(CertificateUtils.appendCertificateMarkers(content).getBytes(StandardCharsets.UTF_8));
        return (T)FACTORY.generateCertificate(is);
    }

    public static String appendCertificateMarkers(String certificate) {
        StringBuilder newCertificate = new StringBuilder();
        if (!certificate.startsWith(BEGIN_CERT_MARKER)) {
            newCertificate.append(BEGIN_CERT_MARKER);
        }
        newCertificate.append(certificate);
        if (!certificate.endsWith(END_CERT_MARKER)) {
            newCertificate.append(END_CERT_MARKER);
        }
        return newCertificate.toString();
    }

    private static KeyPairGenerator getNewGenerator() {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom random = new SecureRandom();
            random.setSeed(CertificateUtils.getRandLong());
            gen.initialize(2048, random);
            return gen;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Error loading provider for RSA algorithm", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static long getRandLong() {
        return System.currentTimeMillis();
    }

    public static List<X509Certificate> buildCertificatePath(Collection<X509Certificate> certs) throws GeneralSecurityException {
        if (certs == null || certs.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<X509Certificate, X509Certificate> certBySignCert = new HashMap<X509Certificate, X509Certificate>();
        X509Certificate rootCert = null;
        ArrayList<X509Certificate> certsCopy = new ArrayList<X509Certificate>(certs);
        for (X509Certificate cert : certs) {
            certsCopy.remove(cert);
            X509Certificate signCert = CertificateUtils.getSigningCert(cert, certs);
            if (signCert == null) {
                if (rootCert == null) {
                    rootCert = cert;
                    continue;
                }
                throw new RuntimeException("Another signing certificate found in: " + certs);
            }
            X509Certificate oldCert = certBySignCert.putIfAbsent(signCert, cert);
            if (oldCert == null) continue;
            throw new RuntimeException("Duplicate target certificates. Previous: " + oldCert + ". New: " + cert + ". Signing certificate: " + signCert + ".");
        }
        if (rootCert == null) {
            throw new RuntimeException("No root signing certificate found in " + certs);
        }
        if (!certsCopy.isEmpty()) {
            throw new RuntimeException("Unrelated certificate(s) found: " + certsCopy + ". Original collection: " + certs);
        }
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        result.add(rootCert);
        X509Certificate signCert = rootCert;
        X509Certificate cert;
        while ((cert = (X509Certificate)certBySignCert.remove(signCert)) != null) {
            result.add(0, cert);
            signCert = cert;
        }
        return result;
    }

    private static final X509Certificate getSigningCert(X509Certificate cert, Collection<X509Certificate> certificates) throws GeneralSecurityException {
        X500Principal issuerPrincipal = cert.getIssuerX500Principal();
        for (X509Certificate signCert : certificates) {
            X500Principal subjectPrincipal;
            if (signCert.equals(cert) || !issuerPrincipal.equals(subjectPrincipal = signCert.getIssuerX500Principal())) continue;
            try {
                cert.verify(signCert.getPublicKey());
            }
            catch (GeneralSecurityException e) {
                LOGGER.warn("Target certificate '{}' issuer principal  == singing certificate '{}' subject prinicipal. Public key validation failed.", new Object[]{cert, signCert, e});
                throw e;
            }
            return signCert;
        }
        return null;
    }

    public static String getThumbprint(String certificate) throws UnsupportedEncodingException, CertificateException, NoSuchAlgorithmException {
        X509Certificate cert = (X509Certificate)CertificateUtils.getCertificate(certificate);
        return CertificateUtils.getThumbprint(cert);
    }

    public static String getThumbprint(Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance(THUMBPRINT_ALGORITHM);
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return CertificateUtils.hexify(digest);
    }

    public static String encode(X509Certificate certificate) throws CertificateEncodingException {
        return Base64.getEncoder().encodeToString(certificate.getEncoded());
    }

    private static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
            if (i == bytes.length - 1) continue;
            buf.append(":");
        }
        return buf.toString().toUpperCase(Locale.ENGLISH);
    }

    static {
        CertificateFactory factory;
        LOGGER = LoggerFactory.getLogger(CertificateUtils.class);
        Security.addProvider((Provider)new BouncyCastleFipsProvider());
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("X.509 certificate factory failed.", e);
        }
        FACTORY = factory;
    }

    private static class AliasGen {
        private static final String PREFIX = "srm_cert_";
        private final AtomicInteger index = new AtomicInteger(0);

        private AliasGen() {
        }

        String next() {
            return PREFIX + this.index.getAndIncrement();
        }
    }
}

