/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.FixedVersionServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.HttpConfigManagerUtils;
import com.vmware.vim.binding.sso.admin.ServiceContent;
import com.vmware.vim.binding.sso.admin.ServiceInstance;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.sso.version.version2;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.KeyStore;
import org.apache.commons.lang.StringUtils;

public class SsoServiceImpl
extends FixedVersionServiceImpl<ServiceInstance, ServiceContent> {
    public static final Class<? extends Annotation> VERSION = version2.class;
    private static final ManagedObjectReference SERVICE_INSTANCE;
    public static final VmodlContextInitializer VMODL_INIT;

    public SsoServiceImpl(URI server, String thumbprint, KeyStore store, TokenProvider provider) {
        super(server, HttpConfigManagerUtils.COMMON_MANAGER.getConfiguration(), VMODL_INIT, provider, SERVICE_INSTANCE, "SSO Management Server", VERSION);
        if (!StringUtils.isEmpty((String)thumbprint)) {
            HttpConfigManagerUtils.COMMON_MANAGER.addThumbprint(thumbprint);
        }
        if (store != null) {
            HttpConfigManagerUtils.COMMON_MANAGER.addThumbprints(store);
        }
    }

    @Override
    protected String getServerGuid(ServiceContent content) {
        return content.getAboutInfo().getDeploymentId();
    }

    @Override
    protected Promise<ServiceContent> retrieveContent(ServiceInstance serviceInstance) {
        FuturePromise result = new FuturePromise();
        serviceInstance.retrieveServiceContent((Future)result);
        return result;
    }

    @Override
    protected Promise<Void> login(ServiceContent content, String locale) {
        return this.createLoginStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.login((Future)result);
            return result;
        });
    }

    @Override
    protected Promise<Void> logout(ServiceContent content) {
        return this.createFreeStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.logout((Future)result);
            return result;
        });
    }

    @Override
    protected boolean retryOnError(Exception err) {
        return err instanceof NotAuthenticated || super.retryOnError(err);
    }

    static {
        VmodlContext context = VmodlContext.initContext((String[])new String[0], (boolean)false);
        VMODL_INIT = new VmodlContextInitializer(context, VERSION);
        SERVICE_INSTANCE = ClientUtils.createMoRef("SsoAdminServiceInstance", "SsoAdminServiceInstance", null);
    }
}

