/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.vim.sso.client.DefaultSecurityTokenServiceFactory;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class StsUtils {
    private static GenericObjectPool.Config getPoolConfig() {
        GenericObjectPool.Config result = new GenericObjectPool.Config();
        result.maxActive = 5;
        result.maxIdle = 2;
        result.minIdle = 1;
        result.whenExhaustedAction = 1;
        result.timeBetweenEvictionRunsMillis = 900000L;
        result.softMinEvictableIdleTimeMillis = 600000L;
        result.minEvictableIdleTimeMillis = -1L;
        return result;
    }

    static ObjectPool createPool(SecurityTokenServiceConfig config) {
        GenericObjectPool pool = new GenericObjectPool((PoolableObjectFactory)new StsFactory(config), StsUtils.getPoolConfig());
        try {
            pool.addObject();
        }
        catch (Exception e) {
            throw Exceptions.getRuntimeException(e);
        }
        return pool;
    }

    private static class StsFactory
    extends BasePoolableObjectFactory {
        private final SecurityTokenServiceConfig _config;

        StsFactory(SecurityTokenServiceConfig config) {
            this._config = config;
        }

        public Object makeObject() throws Exception {
            return DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)this._config);
        }
    }
}

