/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.AutoStartManager;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.host.impl.AutoStartPowerInfoComparator;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmStartupMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VmStartupMutationProvider.class);

    public OperationResult apply(ManagedObjectReference mor, AutoStartManager.Config config) {
        OperationResult result = new OperationResult();
        result.entity = mor;
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
            ConfigManager configManager = host.getConfigManager();
            ManagedObjectReference morAutoStartManager = configManager.getAutoStartManager();
            AutoStartManager autoStartManager = (AutoStartManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)morAutoStartManager);
            if (config.getPowerInfo() != null) {
                Arrays.sort(config.powerInfo, new AutoStartPowerInfoComparator());
                autoStartManager.reconfigure(config);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot reconfigure AutoStartManager", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

