/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.standby;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.host.impl.HostMutationProvider;
import com.vmware.vsphere.client.host.standby.HostStandbySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostStandbyOpManager {
    private static final Log _logger = LogFactory.getLog(HostMutationProvider.class);

    public static OperationResult applyStandbyOp(ManagedObjectReference hostRef, HostStandbySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            result = HostStandbyOpManager.applyStandbyOp(host, spec, result);
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static OperationResult applyStandbyOp(HostSystem host, HostStandbySpec spec, OperationResult result) {
        try {
            if (spec.standbyOpType == HostStandbySpec.StandbyOpType.enter) {
                result.task = host.enterStandbyMode(spec.timeout, spec.evacuatePoweredOffVms);
            }
            if (spec.standbyOpType == HostStandbySpec.StandbyOpType.exit) {
                result.task = host.exitStandbyMode(spec.timeout);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

