/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.util;

import com.vmware.vim.binding.vim.host.PciDevice;
import com.vmware.vim.binding.vim.host.PhysicalNic;

public class NetworkDeviceUtil {
    public static int compareNicDevices(String nic1, String nic2, String nicPrefix) {
        if (nic1 == null && nic2 == null) {
            return 0;
        }
        if (nic1 == null) {
            return -1;
        }
        if (nic2 == null) {
            return 1;
        }
        String nic1Index = nic1.replace(nicPrefix, "");
        String nic2Index = nic2.replace(nicPrefix, "");
        Integer nic1Number = null;
        Integer nic2Number = null;
        try {
            nic1Number = Integer.parseInt(nic1Index);
            nic2Number = Integer.parseInt(nic2Index);
        }
        catch (NumberFormatException nfe) {
            return nic1.compareTo(nic2);
        }
        return nic1Number.compareTo(nic2Number);
    }

    public static PciDevice getPciDevice(PhysicalNic pnic, PciDevice[] pciDevices) {
        PciDevice pciDevice = null;
        if (pciDevices != null) {
            for (PciDevice pci : pciDevices) {
                if (!pnic.getPci().equals(pci.getId())) continue;
                pciDevice = pci;
            }
        }
        return pciDevice;
    }
}

