/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.config.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.host.EsxAgentHostManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.host.config.AgentVmSettingsResult;
import com.vmware.vsphere.client.h5.host.config.spec.AgentVmSettingsSpec;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;

public class FullAgentVmSettingsProvider
implements PropertyProviderBean,
MutationProvider {
    private static final String IS_UPLINK_PORTGROUP = "isUplinkPortgroup";
    private static final String HS_AGENT_VM_DATASTORE = "summary.config.agentVmDatastore";
    private static final String HS_AGENT_VM_NETWORK = "summary.config.agentVmNetwork";
    private static final String HS_ESX_AGENT_HOST_MANAGER = "configManager.esxAgentHostManager";
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public FullAgentVmSettingsProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._querySpecBuilder = querySpecBuilder;
        this._queryExecutor = queryExecutor;
    }

    @type(value="HostSystem")
    public AgentVmSettingsResult getFullAgentVmSettings(ManagedObjectReference hostRef) throws Exception {
        ResultSet rawData = this._queryExecutor.getData(this.buildQuery(hostRef));
        AgentVmSettingsResult result = this.createDataFromResultSet(rawData);
        return result;
    }

    public OperationResult apply(ManagedObjectReference hostRef, AgentVmSettingsSpec spec) {
        Validate.notNull((Object)spec);
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        EsxAgentHostManager.ConfigInfo configInfo = new EsxAgentHostManager.ConfigInfo();
        try {
            configInfo.agentVmDatastore = spec.datastore;
            configInfo.agentVmNetwork = spec.network;
            ManagedObjectReference managerRef = (ManagedObjectReference)this._queryExecutor.getProperty((Object)hostRef, HS_ESX_AGENT_HOST_MANAGER);
            EsxAgentHostManager manager = (EsxAgentHostManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
            manager.updateConfig(configInfo);
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private QuerySpec buildQuery(ManagedObjectReference hostRef) {
        ObjectIdentityConstraint hostConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)hostRef);
        Constraint networkConstraint = this.buildNetworkConstraint((Constraint)hostConstraint);
        Constraint datastoreConstraint = this.buildDatastoreConstraint((Constraint)hostConstraint);
        Constraint constraint = this._querySpecBuilder.combineIntoSingleConstraint(new Constraint[]{hostConstraint, networkConstraint, datastoreConstraint}, Conjoiner.OR);
        QuerySpec query = this._querySpecBuilder.buildQuerySpec(constraint, new String[]{"name", HS_AGENT_VM_DATASTORE, HS_AGENT_VM_NETWORK});
        return query;
    }

    private Constraint buildNetworkConstraint(Constraint hostConstraint) {
        RelationalConstraint allHostNetworks = this._querySpecBuilder.createRelationalConstraint("allNetwork", hostConstraint, Boolean.valueOf(true), "AnyNetwork");
        Constraint nwOnlyConstraint = new Constraint();
        nwOnlyConstraint.targetType = Network.class.getSimpleName();
        Constraint opaqueNwConstraint = new Constraint();
        opaqueNwConstraint.targetType = OpaqueNetwork.class.getSimpleName();
        PropertyConstraint nonUplinkConstraint = this._querySpecBuilder.createPropertyConstraint(DistributedVirtualPortgroup.class.getSimpleName(), IS_UPLINK_PORTGROUP, Comparator.EQUALS, (Object)false);
        Constraint nonUplinkNwConstraint = this._querySpecBuilder.combineIntoSingleConstraint(new Constraint[]{nwOnlyConstraint, opaqueNwConstraint, nonUplinkConstraint}, Conjoiner.OR);
        Constraint networkConstraint = this._querySpecBuilder.combineIntoSingleConstraint(new Constraint[]{allHostNetworks, nonUplinkNwConstraint}, Conjoiner.AND);
        return networkConstraint;
    }

    private Constraint buildDatastoreConstraint(Constraint hostConstraint) {
        RelationalConstraint dsConstraint = this._querySpecBuilder.createRelationalConstraint("datastore", hostConstraint, Boolean.valueOf(true), "Datastore");
        return dsConstraint;
    }

    private AgentVmSettingsResult createDataFromResultSet(ResultSet resultSet) {
        ManagedObjectReference selectedDatastore = null;
        ManagedObjectReference selectedNetwork = null;
        ArrayList<NameValuePair> networks = new ArrayList<NameValuePair>();
        ArrayList<NameValuePair> datastores = new ArrayList<NameValuePair>();
        String NO_DATA = "--";
        datastores.add(new NameValuePair(NO_DATA, null));
        networks.add(new NameValuePair(NO_DATA, null));
        for (ResultItem item : resultSet.items) {
            ManagedObjectReference objRef = (ManagedObjectReference)item.resourceObject;
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, HostSystem.class)) {
                PropertyValue selectedDatastoreProperty = ResultUtil.getPropertyValue((ResultItem)item, (String)HS_AGENT_VM_DATASTORE);
                selectedDatastore = selectedDatastoreProperty == null ? null : (ManagedObjectReference)selectedDatastoreProperty.value;
                PropertyValue selectedNetworkProperty = ResultUtil.getPropertyValue((ResultItem)item, (String)HS_AGENT_VM_NETWORK);
                if (selectedNetworkProperty == null) {
                    selectedNetwork = null;
                    continue;
                }
                selectedNetwork = (ManagedObjectReference)selectedNetworkProperty.value;
                continue;
            }
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, Datastore.class)) {
                datastores.add(this.nameAndObjRef(item, objRef));
                continue;
            }
            if (!ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, Network.class) && !ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, OpaqueNetwork.class) && !ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, DistributedVirtualPortgroup.class)) continue;
            networks.add(this.nameAndObjRef(item, objRef));
        }
        return new AgentVmSettingsResult(datastores, selectedDatastore, networks, selectedNetwork);
    }

    private NameValuePair nameAndObjRef(ResultItem item, ManagedObjectReference objRef) {
        return new NameValuePair((String)ResultUtil.getPropertyValue((ResultItem)item, (String)"name").value, (Object)objRef);
    }
}

