/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.config.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.host.PciDevice;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.host.config.HostPnicFirmwareDetailsItem;
import com.vmware.vsphere.client.h5.host.model.HostPnicFirmwareDetailsData;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import com.vmware.vsphere.client.network.util.NetworkDeviceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HostPnicFirmwareDetailsPropertyProvider
implements PropertyProviderBean {
    public static final String PNIC_DEVICE_PREFIX = "vmnic";
    private final QueryBindingService _queryBindingService;

    public HostPnicFirmwareDetailsPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @PropertyProvider(value="HostSystem/hostPnicFirmwareDetails")
    public HostPnicFirmwareDetailsItem[] getHostPnicFirmwareDetails(ManagedObjectReference hostMor) {
        if (hostMor == null) {
            return null;
        }
        List<HostPnicFirmwareDetailsItem> hostPnicData = new ArrayList<HostPnicFirmwareDetailsItem>();
        HostPnicFirmwareDetailsData hostPnicFirmwareDetailsData = (HostPnicFirmwareDetailsData)((Object)this._queryBindingService.prepare(HostPnicFirmwareDetailsData.class).fetch((Object)hostMor));
        PhysicalNic[] physicalNics = null;
        PciDevice[] hostPciDevices = null;
        if (hostPnicFirmwareDetailsData != null) {
            physicalNics = hostPnicFirmwareDetailsData.pnics;
            hostPciDevices = hostPnicFirmwareDetailsData.pciDevices;
        }
        if (physicalNics == null || hostPciDevices == null) {
            return null;
        }
        for (PhysicalNic pnic : physicalNics) {
            if (pnic == null) continue;
            HostPnicFirmwareDetailsItem item = new HostPnicFirmwareDetailsItem();
            PciDevice pciDevice = NetworkDeviceUtil.getPciDevice((PhysicalNic)pnic, (PciDevice[])hostPciDevices);
            item.deviceModel = pciDevice == null || StringUtils.isEmpty((CharSequence)pciDevice.vendorName) || StringUtils.isEmpty((CharSequence)pciDevice.deviceName) ? HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]) : String.format("%s %s", pciDevice.vendorName, pciDevice.deviceName);
            item.device = HostPnicFirmwareDetailsPropertyProvider.getItemLabel(pnic.device);
            item.driver = HostPnicFirmwareDetailsPropertyProvider.getItemLabel(pnic.driver);
            item.firmwareVersion = HostPnicFirmwareDetailsPropertyProvider.getItemLabel(pnic.firmwareVersion);
            item.driverVersion = HostPnicFirmwareDetailsPropertyProvider.getItemLabel(pnic.driverVersion);
            hostPnicData.add(item);
        }
        hostPnicData = HostPnicFirmwareDetailsPropertyProvider.sortPnicsByDeviceNumerically(hostPnicData);
        return hostPnicData.toArray(new HostPnicFirmwareDetailsItem[0]);
    }

    private static String getItemLabel(String propertyValue) {
        return StringUtils.isNotEmpty((CharSequence)propertyValue) && !propertyValue.equals(HostStringUtil.getString("host.hardware.firmware.na.value", new String[0])) ? propertyValue : HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
    }

    public static List<HostPnicFirmwareDetailsItem> sortPnicsByDeviceNumerically(List<HostPnicFirmwareDetailsItem> pnicItems) {
        if (pnicItems == null) {
            return null;
        }
        Collections.sort(pnicItems, new Comparator<HostPnicFirmwareDetailsItem>(){

            @Override
            public int compare(HostPnicFirmwareDetailsItem item1, HostPnicFirmwareDetailsItem item2) {
                if (item1 == null) {
                    return -1;
                }
                if (item2 == null) {
                    return 1;
                }
                return NetworkDeviceUtil.compareNicDevices((String)item1.device, (String)item2.device, (String)HostPnicFirmwareDetailsPropertyProvider.PNIC_DEVICE_PREFIX);
            }
        });
        return pnicItems;
    }
}

