/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.config.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.host.HardwareStatusInfo;
import com.vmware.vim.binding.vim.host.HealthStatusSystem;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.host.config.HostStorageAdapterFirmwareDetailsItem;
import com.vmware.vsphere.client.h5.host.model.HostStorageAdapterFirmwareDetailsData;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import com.vmware.vsphere.client.network.util.NetworkDeviceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostStorageAdapterFirmwareDetailsPropertyProvider
implements PropertyProviderBean {
    public static final String SA_DEVICE_PREFIX = "vmhba";
    public static final String SA_FIRMWARE_VERSION_PROPERTY = "%s-firmware-version";
    public static final String SA_DRIVER_VERSION_PROPERTY = "%s-driver-version";
    private final QueryBindingService _queryBindingService;
    private static final Log _logger = LogFactory.getLog(HostStorageAdapterFirmwareDetailsPropertyProvider.class);

    public HostStorageAdapterFirmwareDetailsPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @PropertyProvider(value="HostSystem/hostStorageAdapterFirmwareDetails")
    public HostStorageAdapterFirmwareDetailsItem[] getHostStorageAdapterFirmwareDetails(ManagedObjectReference hostMor) {
        if (hostMor == null) {
            return null;
        }
        List<HostStorageAdapterFirmwareDetailsItem> hostHbasData = new ArrayList<HostStorageAdapterFirmwareDetailsItem>();
        HostStorageAdapterFirmwareDetailsData hostSaFirmwareDetailsData = (HostStorageAdapterFirmwareDetailsData)((Object)this._queryBindingService.prepare(HostStorageAdapterFirmwareDetailsData.class).fetch((Object)hostMor));
        HostBusAdapter[] hbas = null;
        ManagedObjectReference healthStatusSystem = null;
        if (hostSaFirmwareDetailsData != null) {
            hbas = hostSaFirmwareDetailsData.adapter;
            healthStatusSystem = hostSaFirmwareDetailsData.healthStatusSystem;
        }
        if (hbas != null) {
            HardwareStatusInfo hwStatusInfo = HostStorageAdapterFirmwareDetailsPropertyProvider.getHwStatusInfo(healthStatusSystem);
            Object[] storageStatusInfo = hwStatusInfo.getStorageStatusInfo();
            for (HostBusAdapter hba : hbas) {
                HostStorageAdapterFirmwareDetailsItem item = new HostStorageAdapterFirmwareDetailsItem();
                if (hba == null) continue;
                item.device = HostStorageAdapterFirmwareDetailsPropertyProvider.getItemLabel(hba.getDevice());
                item.deviceModel = HostStorageAdapterFirmwareDetailsPropertyProvider.getItemLabel(hba.getModel());
                item.driver = HostStorageAdapterFirmwareDetailsPropertyProvider.getItemLabel(hba.getDriver());
                String itemFirmwareVersion = null;
                String itemDriverVersion = null;
                if (!ArrayUtils.isEmpty((Object[])storageStatusInfo)) {
                    for (Object statusInfo : storageStatusInfo) {
                        if (statusInfo == null || ArrayUtils.isEmpty((Object[])((HardwareStatusInfo.StorageStatusInfo)statusInfo).operationalInfo)) continue;
                        for (HardwareStatusInfo.StorageStatusInfo.OperationalInfo opInfo : ((HardwareStatusInfo.StorageStatusInfo)statusInfo).operationalInfo) {
                            if (opInfo == null || !StringUtils.isNotEmpty((CharSequence)opInfo.property)) continue;
                            String firmwareVersionKey = String.format(SA_FIRMWARE_VERSION_PROPERTY, hba.getDevice());
                            String driverVersionKey = String.format(SA_DRIVER_VERSION_PROPERTY, hba.getDevice());
                            if (opInfo.property.equals(firmwareVersionKey)) {
                                itemFirmwareVersion = HostStorageAdapterFirmwareDetailsPropertyProvider.getItemLabel(opInfo.value);
                            }
                            if (!opInfo.property.equals(driverVersionKey)) continue;
                            itemDriverVersion = HostStorageAdapterFirmwareDetailsPropertyProvider.getItemLabel(opInfo.value);
                        }
                    }
                }
                item.firmwareVersion = HostStorageAdapterFirmwareDetailsPropertyProvider.getItemLabel(itemFirmwareVersion);
                item.driverVersion = HostStorageAdapterFirmwareDetailsPropertyProvider.getItemLabel(itemDriverVersion);
                hostHbasData.add(item);
            }
            hostHbasData = HostStorageAdapterFirmwareDetailsPropertyProvider.sortSaByDeviceNumerically(hostHbasData);
        }
        return hostHbasData.toArray(new HostStorageAdapterFirmwareDetailsItem[0]);
    }

    private static String getItemLabel(String propertyValue) {
        return StringUtils.isNotEmpty((CharSequence)propertyValue) ? propertyValue : HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
    }

    public static List<HostStorageAdapterFirmwareDetailsItem> sortSaByDeviceNumerically(List<HostStorageAdapterFirmwareDetailsItem> saItems) {
        if (saItems == null) {
            return null;
        }
        Collections.sort(saItems, new Comparator<HostStorageAdapterFirmwareDetailsItem>(){

            @Override
            public int compare(HostStorageAdapterFirmwareDetailsItem item1, HostStorageAdapterFirmwareDetailsItem item2) {
                if (item1 == null) {
                    return -1;
                }
                if (item2 == null) {
                    return 1;
                }
                return NetworkDeviceUtil.compareNicDevices((String)item1.device, (String)item2.device, (String)HostStorageAdapterFirmwareDetailsPropertyProvider.SA_DEVICE_PREFIX);
            }
        });
        return saItems;
    }

    private static HardwareStatusInfo getHwStatusInfo(ManagedObjectReference healthStatusSystemRef) {
        HardwareStatusInfo hwStatusInfo = null;
        try {
            HealthStatusSystem healthStatusSystem = (HealthStatusSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)healthStatusSystemRef);
            HealthStatusSystem.Runtime runtime = healthStatusSystem.getRuntime();
            hwStatusInfo = runtime.getHardwareStatusInfo();
        }
        catch (Exception e) {
            _logger.error((Object)"Can't get host hardware status info", (Throwable)e);
        }
        return hwStatusInfo;
    }
}

