/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo;

import com.vmware.identity.token.impl.SecureXmlParserFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.SensorFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.ServiceEventLogFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HealthStatus;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HostCimData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.Sensor;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SensorGroup;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SystemEventData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.types.SensorConstants;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HostCimInfoXmlReader {
    private static final Log logger = LogFactory.getLog(HostCimInfoXmlReader.class);
    private static final String GROUP_NAME_SYSTEM_SENSORS_EXPRESSION = "//host[@moid]/group[@name!=\"SystemBoard\" and @name!=\"SELRecords\" and @name!=\"BIOS\"]";
    private static final String GROUP_NAME_SEL_RECORDS_EXPRESSION = "//host[@moid]/group[@name=\"SELRecords\"]/*";
    private static final String MEMORY = "memory";
    private String xml;
    private XPath xpath;
    private Document document;
    private SensorFactory sensorFactory;
    private HostCimData hostCimData;
    private ServiceEventLogFactory serviceEventLogFactory;

    public HostCimInfoXmlReader(String xml, SensorFactory sensorFactory, ServiceEventLogFactory serviceEventLogFactory) {
        this.xml = xml;
        this.sensorFactory = sensorFactory;
        this.serviceEventLogFactory = serviceEventLogFactory;
    }

    public HostCimData parse() {
        this.hostCimData = new HostCimData();
        try {
            this.initializeXmlDocumentAndXpath();
            this.hostCimData.sensors = this.getSensorsData();
            this.hostCimData.systemEventLog = this.getSystemEventLogData();
        }
        catch (Exception e) {
            logger.error((Object)"Error parsing XML document", (Throwable)e);
        }
        return this.hostCimData;
    }

    private void initializeXmlDocumentAndXpath() throws ParserConfigurationException, IOException, SAXException {
        SecureXmlParserFactory factory = new SecureXmlParserFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(new InputSource(new StringReader(this.xml)));
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    private List<Sensor> getSensorsData() {
        ArrayList<Sensor> sensorsData = new ArrayList<Sensor>();
        try {
            NodeList groupNodes = (NodeList)this.xpath.evaluate(GROUP_NAME_SYSTEM_SENSORS_EXPRESSION, this.document, XPathConstants.NODESET);
            if (groupNodes != null && groupNodes.getLength() > 0) {
                for (int i = 0; i < groupNodes.getLength(); ++i) {
                    Node groupNode = groupNodes.item(i);
                    SensorGroup group = this.sensorFactory.createSensorGroup(groupNode, sensorsData.size());
                    sensorsData.add((Sensor)group);
                    this.addSensors(groupNode.getChildNodes(), group, sensorsData);
                    this.hostCimData.sensorCounts.warnings += group.getWarningCount();
                    this.hostCimData.sensorCounts.alerts += group.getAlertCount();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't get sensors data", (Throwable)e);
        }
        return sensorsData;
    }

    private List<SystemEventData> getSystemEventLogData() {
        ArrayList<SystemEventData> systemEventLog = new ArrayList<SystemEventData>();
        try {
            NodeList nodes = (NodeList)this.xpath.evaluate(GROUP_NAME_SEL_RECORDS_EXPRESSION, this.document, XPathConstants.NODESET);
            if (nodes != null && nodes.getLength() > 0) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    systemEventLog.add(this.serviceEventLogFactory.createSystemEventData(nodes.item(i)));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't get system event log data", (Throwable)e);
        }
        return systemEventLog;
    }

    private void addSensors(NodeList childNodes, SensorGroup group, List<Sensor> sensorsData) {
        HashMap<String, Sensor> memorySensors = new HashMap<String, Sensor>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node sensorNode = childNodes.item(i);
            if (sensorNode.getNodeType() != 1) continue;
            Sensor sensor = this.sensorFactory.createSensor(sensorNode, sensorsData.size(), group.sensorType, group.id);
            if (this.isPhysicalOmcMemorySlot(sensorNode.getNodeName(), sensor, memorySensors)) continue;
            group.updateStatus(sensor);
            sensorsData.add(sensor);
            ++this.hostCimData.sensorCounts.all;
            HealthStatus sensorHealthStatus = sensor.healthStatus;
            if (sensorHealthStatus.isNormal()) continue;
            Sensor alertAndWarningSensor = sensor.clone();
            assert (alertAndWarningSensor != null);
            alertAndWarningSensor.parentId = null;
            this.hostCimData.alertsAndWarnings.add(alertAndWarningSensor);
        }
    }

    private boolean isPhysicalOmcMemorySlot(String nodeName, Sensor sensor, Map<String, Sensor> memorySensors) {
        if (MEMORY.equals(sensor.sensorType) && StringUtils.isNotEmpty((CharSequence)sensor.name)) {
            if (SensorConstants.Types.PHYSICAL_MEMORY.getValue().equals(nodeName)) {
                memorySensors.put(sensor.name, sensor);
                return false;
            }
            if (SensorConstants.Types.MEMORY_SLOT.getValue().equals(nodeName) && memorySensors.containsKey(sensor.name)) {
                return true;
            }
        }
        return false;
    }
}

