/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.BaseboardManagementControllerSensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.DefaultSensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.MemorySensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.NetworkSensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.NumericSensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.PciDeviceSensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.PowerSensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.ProcessorSensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.SensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.ServerErrorLogSensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.SoftwareIdentitySensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.VmwareBatterySensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.w3c.dom.Node;

public final class SensorDetailsTypeFactory {
    private SensorDetailsTypeFactory() {
    }

    public static SensorDetailsFactory getDetailsFactory(Node node) {
        DefaultSensorDetailsFactory factory;
        Node parentNode = node.getParentNode();
        SensorConstants.Types type2 = SensorConstants.Types.getSensorTypeByNode(parentNode);
        switch (type2) {
            case MEMORY_SLOT: 
            case MEMORY: {
                factory = new MemorySensorDetailsFactory(node);
                break;
            }
            case NETWORK: {
                factory = new NetworkSensorDetailsFactory(node);
                break;
            }
            case PCI_DEVICE: {
                factory = new PciDeviceSensorDetailsFactory(node);
                break;
            }
            case PROCESSOR: 
            case CACHE_MEMORY: {
                factory = new ProcessorSensorDetailsFactory(node);
                break;
            }
            case BASEBOARD_MANAGEMENT_CONTROLLER_SMX: 
            case BASEBOARD_MANAGEMENT_CONTROLLER_OMC: {
                factory = new BaseboardManagementControllerSensorDetailsFactory(node);
                break;
            }
            case NUMERIC_SENSOR: {
                factory = new NumericSensorDetailsFactory(node);
                break;
            }
            case VMWARE_BATTERY: {
                factory = new VmwareBatterySensorDetailsFactory(node);
                break;
            }
            case SOFTWARE_IDENTITY: {
                factory = new SoftwareIdentitySensorDetailsFactory(node);
                break;
            }
            case SERVER_ERROR_LOG: {
                factory = new ServerErrorLogSensorDetailsFactory(node);
                break;
            }
            case POWER: 
            case DISCRETE_SENSOR: {
                factory = new PowerSensorDetailsFactory(node);
                break;
            }
            default: {
                factory = new DefaultSensorDetailsFactory(node);
            }
        }
        return factory;
    }
}

