/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hci;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vcint.vlcm.ClusterHostSeedingWorkflowSpec;
import com.vmware.vim.binding.vcint.vlcm.ClusterWorkflowManager;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.LifecycleOperationResult;
import com.vmware.vim.binding.vim.host.ConnectSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.host.hci.model.BatchAddHostsSpec;
import com.vmware.vsphere.client.h5.host.hci.model.ClusterFolderData;
import com.vmware.vsphere.client.h5.host.hci.model.HostConnectionData;
import com.vmware.vsphere.client.h5.host.hci.model.HostConnectionSpec;
import com.vmware.vsphere.client.h5.host.hci.model.HostSeedingSpec;
import com.vmware.vsphere.client.h5.host.hci.model.StandaloneHostData;
import com.vmware.vsphere.client.h5.host.hci.model.VerifyLifecycleCompatibilitySpec;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HciClusterPropertyProvider
implements PropertyProviderBean,
MutationProvider {
    private static final Log _logger = LogFactory.getLog(HciClusterPropertyProvider.class);
    private static final String DC_PROPERTY = "dc";
    private static final String HOST_FOLDER_PROPERTY_NAME = "hostFolder";
    private static final String IS_STANDALONE_PROPERTY = "isStandalone";
    private static final String NAME_PROPERTY = "name";
    private static final String DATASTORE_RELATION_PROPERTY = "datastore";
    private static final String NETWORK_RELATION_PROPERTY = "network";
    private static final String POWERED_ON_VMS_PROPERTY = "poweredOnVMs";
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;
    private final QueryBindingService _queryBindingService;

    public HciClusterPropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, QueryBindingService queryBindingService) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._queryBindingService = queryBindingService;
    }

    @type(value="ClusterComputeResource")
    public StandaloneHostData[] getStandaloneHosts(ManagedObjectReference clusterRef) throws Exception {
        ManagedObjectReference datacenterRef = (ManagedObjectReference)this._queryExecutor.getProperty((Object)clusterRef, DC_PROPERTY);
        PropertyConstraint isStandaloneConstraint = this._querySpecBuilder.createPropertyConstraint(HostSystem.class.getSimpleName(), IS_STANDALONE_PROPERTY, Comparator.EQUALS, (Object)true);
        PropertyConstraint dcConstraint = this._querySpecBuilder.createPropertyConstraint(HostSystem.class.getSimpleName(), DC_PROPERTY, Comparator.EQUALS, (Object)datacenterRef);
        Constraint constraint = this._querySpecBuilder.combineIntoSingleConstraint(new Constraint[]{isStandaloneConstraint, dcConstraint}, Conjoiner.AND);
        QuerySpec query = this._querySpecBuilder.buildQuerySpec(constraint, new String[]{NAME_PROPERTY});
        ResultSet resultSet = this._queryExecutor.getData(query);
        ArrayList<ManagedObjectReference> hostRefs = new ArrayList<ManagedObjectReference>();
        for (ResultItem item : resultSet.items) {
            hostRefs.add((ManagedObjectReference)item.resourceObject);
        }
        Collection result = this._queryBindingService.prepare(StandaloneHostData.class).fetch(hostRefs);
        return result.toArray(new StandaloneHostData[result.size()]);
    }

    @type(value="HostSystem")
    public String[] getPoweredOnVmNames(ManagedObjectReference hostRef) throws Exception {
        Object[] vms = (ManagedObjectReference[])this._queryExecutor.getProperty((Object)hostRef, POWERED_ON_VMS_PROPERTY);
        if (vms != null) {
            PropertyValue[] vmNames = this._queryExecutor.getProperty(vms, NAME_PROPERTY);
            return this.getNamePropertyValues(vmNames);
        }
        return new String[0];
    }

    @type(value="HostSystem")
    public String[] getDatastoreNames(ManagedObjectReference hostRef) throws Exception {
        PropertyValue[] datastores = this._queryExecutor.getPropertyForRelatedObjects((Object)hostRef, DATASTORE_RELATION_PROPERTY, Datastore.class.getSimpleName(), NAME_PROPERTY);
        return this.getNamePropertyValues(datastores);
    }

    @type(value="HostSystem")
    public String[] getNetworkNames(ManagedObjectReference hostRef) throws Exception {
        PropertyValue[] networks = this._queryExecutor.getPropertyForRelatedObjects((Object)hostRef, NETWORK_RELATION_PROPERTY, "AnyNetwork", NAME_PROPERTY);
        return this.getNamePropertyValues(networks);
    }

    public ValidationResult validate(ManagedObjectReference clusterRef, HostConnectionSpec[] specs) {
        ValidationResult validationResult = new ValidationResult();
        if (ArrayUtils.isEmpty((Object[])specs)) {
            validationResult.result = new HostConnectionData();
            return validationResult;
        }
        ConnectSpec[] connectSpecs = this.createConnectSpecs(specs, false);
        try {
            Datacenter dc = this.retrieveDc(clusterRef);
            Datacenter.BasicConnectInfo[] basicConnectInfos = dc.batchQueryConnectInfo(connectSpecs);
            HostConnectionData result = new HostConnectionData(basicConnectInfos);
            validationResult.result = result;
        }
        catch (Exception ex) {
            validationResult.error = ex;
            _logger.error((Object)ex);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference clusterRef, VerifyLifecycleCompatibilitySpec spec) {
        ValidationResult validationResult = new ValidationResult();
        ConnectSpec[] connectSpecs = this.createConnectSpecs(spec.nonInventoryHosts, false);
        try {
            Folder parentFolder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.parent);
            LifecycleOperationResult operationResult = parentFolder.verifyLifecycleCompatibility(clusterRef, spec.inventoryHosts, connectSpecs);
            validationResult.result = operationResult.unsupportedHosts;
        }
        catch (Exception ex) {
            validationResult.error = ex;
            _logger.error((Object)ex);
        }
        return validationResult;
    }

    public OperationResult apply(ManagedObjectReference clusterRef, BatchAddHostsSpec spec) {
        OperationResult opResult = new OperationResult();
        try {
            ManagedObjectReference taskRef;
            ClusterFolderData clusterFolderData = (ClusterFolderData)this._queryBindingService.prepare(ClusterFolderData.class).fetch((Object)clusterRef);
            if (clusterFolderData.hostFolder == null) {
                throw new Exception(String.format("Failed to retrieve %1s for %2s", HOST_FOLDER_PROPERTY_NAME, clusterRef.toString()));
            }
            Folder folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterFolderData.hostFolder);
            ConnectSpec[] connectSpecs = this.createConnectSpecs(spec.hostConnectionSpecs, true);
            ArrayList<Folder.NewHostSpec> newHostSpecs = new ArrayList<Folder.NewHostSpec>();
            for (ConnectSpec connectSpec : connectSpecs) {
                Folder.NewHostSpec newHostSpec = new Folder.NewHostSpec();
                newHostSpec.hostCnxSpec = connectSpec;
                newHostSpecs.add(newHostSpec);
            }
            String desiredHostState = null;
            if (this.isHciWorkflowStateValid(clusterFolderData.hciConfigInfo)) {
                desiredHostState = Folder.DesiredHostState.maintenance.name();
            }
            if (spec.hostSeedingSpec != null) {
                ClusterHostSeedingWorkflowSpec.AddHostsSpec addHostsSpec = new ClusterHostSeedingWorkflowSpec.AddHostsSpec(newHostSpecs.toArray(new Folder.NewHostSpec[newHostSpecs.size()]), spec.existingHostMoRefs, desiredHostState);
                ClusterHostSeedingWorkflowSpec clusterHostSeedingWorkflowSpec = this.getClusterHostSeedingWorkflowSpec(spec.hostSeedingSpec, clusterRef, addHostsSpec);
                ClusterWorkflowManager clusterWorkflowManager = this.getClusterWorkflowManager(clusterRef.getServerGuid());
                taskRef = clusterWorkflowManager.executeClusterHostSeedingWorkflow(clusterHostSeedingWorkflowSpec);
            } else {
                taskRef = folder.batchAddHostsToCluster(clusterRef, newHostSpecs.toArray(new Folder.NewHostSpec[newHostSpecs.size()]), spec.existingHostMoRefs, null, desiredHostState);
            }
            opResult.task = taskRef;
        }
        catch (Exception ex) {
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    private Datacenter retrieveDc(ManagedObjectReference clusterRef) throws Exception {
        ManagedObjectReference dcMoref = (ManagedObjectReference)this._queryExecutor.getProperty((Object)clusterRef, DC_PROPERTY);
        if (dcMoref == null) {
            throw new Exception(String.format("Failed to retrieve %1s for %2s", DC_PROPERTY, clusterRef.toString()));
        }
        Datacenter dc = (Datacenter)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dcMoref);
        return dc;
    }

    private ConnectSpec[] getConnectSpecs(HostConnectionSpec[] specs) {
        ConnectSpec[] result = new ConnectSpec[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            HostConnectionSpec hostConnectionSpec = specs[i];
            ConnectSpec connectSpec = new ConnectSpec();
            connectSpec.hostName = hostConnectionSpec.hostname;
            connectSpec.userName = hostConnectionSpec.username;
            connectSpec.password = hostConnectionSpec.password;
            result[i] = connectSpec;
        }
        return result;
    }

    private ConnectSpec[] createConnectSpecs(HostConnectionSpec[] specs, boolean replaceNegativePort) {
        ConnectSpec[] result = new ConnectSpec[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            ConnectSpec item = new ConnectSpec();
            HostConnectionSpec spec = specs[i];
            item.hostName = spec.hostname;
            item.userName = spec.username;
            item.password = spec.password;
            item.port = !replaceNegativePort || spec.port != -1 ? Integer.valueOf(spec.port) : null;
            item.sslThumbprint = spec.sslThumbprint;
            item.force = true;
            result[i] = item;
        }
        return result;
    }

    private String[] getNamePropertyValues(PropertyValue[] propertyValues) {
        ArrayList<String> result = new ArrayList<String>();
        for (PropertyValue value : propertyValues) {
            if (!value.propertyName.equals(NAME_PROPERTY)) continue;
            result.add((String)value.value);
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean isHciWorkflowStateValid(ClusterComputeResource.HCIConfigInfo hciConfigInfo) {
        return hciConfigInfo != null && (ClusterComputeResource.HCIWorkflowState.in_progress.name().equals(hciConfigInfo.workflowState) || ClusterComputeResource.HCIWorkflowState.done.name().equals(hciConfigInfo.workflowState));
    }

    /*
     * Enabled aggressive block sorting
     */
    private ClusterHostSeedingWorkflowSpec getClusterHostSeedingWorkflowSpec(HostSeedingSpec spec, ManagedObjectReference clusterRef, ClusterHostSeedingWorkflowSpec.AddHostsSpec addHostsSpec) throws Exception {
        ClusterHostSeedingWorkflowSpec.HostsSeedSpec.SingleHostSpec singleHostSpec = new ClusterHostSeedingWorkflowSpec.HostsSeedSpec.SingleHostSpec();
        if (spec.newHost != null) {
            ConnectSpec[] connectSpecs = this.createConnectSpecs(new HostConnectionSpec[]{spec.newHost}, true);
            if (connectSpecs.length <= 0) {
                _logger.error((Object)"No connection spec generated");
                throw new Exception("No connectuion spec generated");
            }
            ConnectSpec connectSpec = connectSpecs[0];
            singleHostSpec.setNewHostCnxSpec(connectSpec);
        } else {
            singleHostSpec.setExistingHost(spec.existingHostMor);
        }
        ClusterHostSeedingWorkflowSpec.HostsSeedSpec hostsSeedSpec = new ClusterHostSeedingWorkflowSpec.HostsSeedSpec(singleHostSpec);
        ClusterHostSeedingWorkflowSpec.ClusterSpec.ManagementSpec clusterManagementSpec = new ClusterHostSeedingWorkflowSpec.ClusterSpec.ManagementSpec(clusterRef);
        ClusterHostSeedingWorkflowSpec.ClusterSpec clusterSpec = new ClusterHostSeedingWorkflowSpec.ClusterSpec();
        clusterSpec.setManagementSpec(clusterManagementSpec);
        return new ClusterHostSeedingWorkflowSpec(hostsSeedSpec, clusterSpec, addHostsSpec);
    }

    private ClusterWorkflowManager getClusterWorkflowManager(String vcId) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)vcId);
        if (vcService == null) {
            _logger.error((Object)("No VcService found in session for VC ID: " + vcId));
            throw new Exception("No VcService found in session for VC ID: " + vcId);
        }
        ManagedObjectReference clusterWorkflowManagerMor = new ManagedObjectReference("VcintVlcmClusterWorkflowManager", "vcint-cluster-workflow-manager", vcId);
        return (ClusterWorkflowManager)vcService.getManagedObject(clusterWorkflowManagerMor);
    }
}

