/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.GraphicsConfig;
import com.vmware.vim.binding.vim.host.GraphicsInfo;
import com.vmware.vise.util.Version;
import com.vmware.vsphere.client.h5.host.model.GraphicInfo;

@QueryBinding(value="HostSystem")
public class GraphicsData
extends IdentifiableQueryBinding {
    private static final Version VERSION_6_1 = new Version("6.1.0");
    @Property(value="HostSystem/config/graphicsConfig")
    protected transient GraphicsConfig graphicsConfig;
    @Property(value="HostSystem/config/graphicsInfo")
    protected transient GraphicsInfo[] graphicsInfo;
    @Property(value="HostSystem/config/product/version")
    protected transient String hostVersion;

    public GraphicInfo[] getGraphicsInformation() {
        if (this.graphicsInfo == null) {
            return new GraphicInfo[0];
        }
        GraphicInfo[] result = new GraphicInfo[this.graphicsInfo.length];
        for (int i = 0; i < this.graphicsInfo.length; ++i) {
            GraphicsInfo info = this.graphicsInfo[i];
            GraphicInfo tempInfo = new GraphicInfo();
            tempInfo.deviceName = info.getDeviceName();
            tempInfo.vendor = info.getVendorName();
            tempInfo.defaultType = info.getGraphicsType();
            tempInfo.pciId = info.getPciId();
            tempInfo.configuredType = this.getConfiguredType(info);
            tempInfo.memory = info.getMemorySizeInKB() * 1024L;
            tempInfo.vms = info.getVm();
            tempInfo.sharedPassthruAssignmentPolicy = this.getSharedPassthruAssignmentPolicy();
            result[i] = tempInfo;
        }
        return result;
    }

    public String getSharedPassthruAssignmentPolicy() {
        return this.isGraphicsConfigAvailable() ? this.graphicsConfig.getSharedPassthruAssignmentPolicy() : "";
    }

    public String getDefaultGraphicsType() {
        return this.isGraphicsConfigAvailable() ? this.graphicsConfig.getHostDefaultGraphicsType() : "";
    }

    public boolean getIsHostSettingsEnabled() {
        return this.getIsVersion65OrLater();
    }

    private boolean getIsVersion65OrLater() {
        Version currentHostVersion = new Version(this.hostVersion);
        return currentHostVersion.compareTo(VERSION_6_1) >= 0;
    }

    private String getConfiguredType(GraphicsInfo info) {
        String configuredType = "";
        if (!this.isGraphicsConfigAvailable() || this.graphicsConfig.deviceType == null) {
            return configuredType;
        }
        for (GraphicsConfig.DeviceType deviceType : this.graphicsConfig.deviceType) {
            if (!info.getPciId().equals(deviceType.getDeviceId())) continue;
            return deviceType.getGraphicsType();
        }
        return configuredType;
    }

    private boolean isGraphicsConfigAvailable() {
        return this.graphicsConfig != null;
    }
}

