/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.host.VirtualNicManagerInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.host.config.spec.PtpTimeConfigVnicSpec;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import com.vmware.vsphere.client.h5.host.util.TimeConfigUtil;
import java.util.ArrayList;
import java.util.List;

@QueryBinding(value="HostSystem")
public class PtpTimeConfigData
extends IdentifiableQueryBinding {
    private static final String PTP_SERVICE_KEY = "ptpd";
    @Property(value="HostSystem/config/service")
    public transient ServiceInfo services;
    @Property(value="HostSystem/config/firewall")
    public transient FirewallInfo firewallInfo;
    @Property(value="HostSystem/capability/precisionTimeProtocolSupported")
    public boolean isPrecisionTimeProtocolSupported;

    public String getPtpServiceStatus() {
        return TimeConfigUtil.getServiceStatus(this.services, PTP_SERVICE_KEY);
    }

    public String getPtpClientStatusLabel() {
        return TimeConfigUtil.getClientStatus(this.firewallInfo, PTP_SERVICE_KEY);
    }

    public boolean getPtpClientStatus() {
        return TimeConfigUtil.getClientEnabled(this.firewallInfo, PTP_SERVICE_KEY);
    }

    public List<PtpTimeConfigVnicSpec> getAllVnicsData() {
        if (this.getPtpNetConfig() != null) {
            VirtualNic[] ptpVnics = this.getPtpNetConfig().getCandidateVnic();
            ArrayList<PtpTimeConfigVnicSpec> ptpVnicsData = new ArrayList<PtpTimeConfigVnicSpec>(ptpVnics.length);
            for (VirtualNic vnic : ptpVnics) {
                PtpTimeConfigVnicSpec ptpVnic = new PtpTimeConfigVnicSpec();
                ptpVnic.vnic = vnic.device;
                ptpVnic.ipAddress = vnic.spec.ip.ipAddress;
                ptpVnic.subnetMask = vnic.spec.ip.subnetMask;
                ptpVnic.vnicKey = vnic.key;
                ptpVnicsData.add(ptpVnic);
            }
            return ptpVnicsData;
        }
        return null;
    }

    public PtpTimeConfigVnicSpec getPtpVnicData() {
        PtpTimeConfigVnicSpec empty = this.emptyData();
        VirtualNicManager.NetConfig ptpNetConfig = this.getPtpNetConfig();
        if (ptpNetConfig == null) {
            return empty;
        }
        String[] selectedVnic = ptpNetConfig.getSelectedVnic();
        if (selectedVnic == null) {
            return empty;
        }
        String ptpVnic = selectedVnic[0];
        if (ptpVnic != null) {
            List<PtpTimeConfigVnicSpec> allVnics = this.getAllVnicsData();
            for (PtpTimeConfigVnicSpec vnicData : allVnics) {
                if (!ptpVnic.equals(vnicData.vnicKey)) continue;
                return vnicData;
            }
        }
        return empty;
    }

    private PtpTimeConfigVnicSpec emptyData() {
        String empty = HostStringUtil.getString("host.hardware.firmware.na.label", new String[0]);
        PtpTimeConfigVnicSpec emptyData = new PtpTimeConfigVnicSpec();
        emptyData.ipAddress = empty;
        emptyData.subnetMask = empty;
        emptyData.vnic = empty;
        return emptyData;
    }

    public boolean getPtpServiceState() {
        Service service = TimeConfigUtil.getService(this.services, PTP_SERVICE_KEY);
        return service == null ? false : service.isRunning();
    }

    private VirtualNicManager.NetConfig getPtpNetConfig() {
        try {
            VirtualNicManager.NetConfig[] netConfig;
            ManagedObjectReference hostMor = (ManagedObjectReference)this.provider;
            HostSystem hostSystem = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostMor);
            ConfigManager configManager = hostSystem.getConfigManager();
            ManagedObjectReference vnicMgrMor = configManager.getVirtualNicManager();
            VirtualNicManager vNicManager = (VirtualNicManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vnicMgrMor);
            VirtualNicManagerInfo info = vNicManager.getInfo();
            for (VirtualNicManager.NetConfig config : netConfig = info.netConfig) {
                if (!config.getNicType().equals(VirtualNicManager.NicType.ptp.name())) continue;
                return config;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }
}

