/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.system.securityprofile;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.h5.host.system.securityprofile.SecurityProfileData;
import java.util.List;

public class SecurityProfilePropertyProvider
implements PropertyProviderBean {
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private QueryService _queryService;
    private QueryBindingService _queryBindingService;

    public SecurityProfilePropertyProvider(QueryBindingService _queryBindingService, QueryService _queryService) {
        this._queryBindingService = _queryBindingService;
        this._queryService = _queryService;
    }

    @type(value="HostSystem")
    public SecurityProfileData getSecurityProfileSummaryData(ManagedObjectReference hostRef) {
        boolean isHostConnected = this.isHostConnected(hostRef);
        return isHostConnected ? (SecurityProfileData)this._queryBindingService.prepare(SecurityProfileData.class).fetch((Object)hostRef) : null;
    }

    private boolean isHostConnected(ManagedObjectReference hostRef) {
        ResultSet resultSetFromQuery = this._queryService.select(new String[]{HOST_CONNECTION_STATE_PROPERTY}).from(new String[]{hostRef.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef).fetch();
        boolean isHostConnected = false;
        if (resultSetFromQuery != null && resultSetFromQuery.getItems() != null && resultSetFromQuery.getItems().size() > 0) {
            List resourceItemsList = resultSetFromQuery.getItems();
            HostSystem.ConnectionState currentConnectionState = (HostSystem.ConnectionState)((ResourceItem)resourceItemsList.get(0)).getPropertyValues().get(0);
            isHostConnected = HostSystem.ConnectionState.connected == currentConnectionState;
        }
        return isHostConnected;
    }
}

