/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.vmdp;

import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import com.vmware.vsphere.client.h5.host.vmdp.VmdpDeviceStatus;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class VmdpDeviceInfoUtil {
    private static final Map<Integer, String> deviceNameMapping = new HashMap<Integer, String>(){
        {
            this.put(0, "vmdpConfig.GenericPreVgaDevice.label");
            this.put(1, "vmdpConfig.GenericVgaDevice.label");
            this.put(256, "vmdpConfig.GenericScsiController.label");
            this.put(257, "vmdpConfig.GenericIdeController.label");
            this.put(258, "vmdpConfig.GenericFloppyDiskController.label");
            this.put(259, "vmdpConfig.GenericIpiController.label");
            this.put(260, "vmdpConfig.GenericRaidController.label");
            this.put(384, "vmdpConfig.GenericMassStorageController.label");
            this.put(512, "vmdpConfig.GenericEthernetController.label");
            this.put(513, "vmdpConfig.GenericTokenRingController.label");
            this.put(514, "vmdpConfig.GenericFddiController.label");
            this.put(515, "vmdpConfig.GenericAtmController.label");
            this.put(640, "vmdpConfig.GenericNetworkController.label");
            this.put(768, "vmdpConfig.GenericVgaCompatController.label");
            this.put(769, "vmdpConfig.GenericXgaCompatController.label");
            this.put(896, "vmdpConfig.GenericDisplayController.label");
            this.put(1024, "vmdpConfig.GenericVideoDevice.label");
            this.put(1025, "vmdpConfig.GenericAudioDevice.label");
            this.put(1152, "vmdpConfig.GenericMultimediaDevice.label");
            this.put(1280, "vmdpConfig.GenericRamController.label");
            this.put(1281, "vmdpConfig.GenericFlashMemoryController.label");
            this.put(1408, "vmdpConfig.GenericMemoryController.label");
            this.put(1536, "vmdpConfig.GenericHostPciBridge.label");
            this.put(1537, "vmdpConfig.GenericPciIsaBridge.label");
            this.put(1538, "vmdpConfig.GenericPciEisaBridge.label");
            this.put(1539, "vmdpConfig.GenericPciMicroChannelBridge.label");
            this.put(1540, "vmdpConfig.GenericPciPciBridge.label");
            this.put(1541, "vmdpConfig.GenericPciPcmciaBridge.label");
            this.put(1542, "vmdpConfig.GenericPciNubusBridge.label");
            this.put(1543, "vmdpConfig.GenericPciCardbusBridge.label");
            this.put(1664, "vmdpConfig.GenericOtherBridgeType.label");
            this.put(1792, "vmdpConfig.GenericSerialPort.label");
            this.put(1793, "vmdpConfig.GenericParallelPort.label");
            this.put(1920, "vmdpConfig.GenericCommunicationsDevice.label");
            this.put(2048, "vmdpConfig.GenericPIC.label");
            this.put(2049, "vmdpConfig.GenericDmaController.label");
            this.put(2050, "vmdpConfig.GenericSystemTimer.label");
            this.put(2051, "vmdpConfig.GenericRtcController.label");
            this.put(2176, "vmdpConfig.GenericSystemPeripheral.label");
            this.put(2304, "vmdpConfig.GenericKeyboardController.label");
            this.put(2305, "vmdpConfig.GenericDigitizer.label");
            this.put(2306, "vmdpConfig.GenericMouseController.label");
            this.put(2432, "vmdpConfig.GenericInputController.label");
            this.put(2560, "vmdpConfig.GenericGenericDockingStation.label");
            this.put(2688, "vmdpConfig.GenericDockingStation.label");
            this.put(2816, "vmdpConfig.Generic386Processor.label");
            this.put(2817, "vmdpConfig.Generic486Processor.label");
            this.put(2818, "vmdpConfig.GenericPentiumProcessor.label");
            this.put(2832, "vmdpConfig.GenericAlphaProcessor.label");
            this.put(2848, "vmdpConfig.GenericPowerPcProcessor.label");
            this.put(2880, "vmdpConfig.GenericCoprocessor.label");
            this.put(3072, "vmdpConfig.GenericFirewire.label");
            this.put(3073, "vmdpConfig.GenericAccessBus.label");
            this.put(3074, "vmdpConfig.GenericSsa.label");
            this.put(3075, "vmdpConfig.GenericUsb.label");
        }
    };

    private VmdpDeviceInfoUtil() {
    }

    public static String getVmdprDeviceInfoName(String deviceName, short classId) {
        if (!"Unknown".equals(deviceName)) {
            return deviceName;
        }
        Integer unsignedShort = classId >= 0 ? classId : 65536 + classId;
        String key = deviceNameMapping.get(unsignedShort);
        if (key == null) {
            key = "vmdpConfig.GenericUnknown.label";
        }
        return HostStringUtil.getString(key, new String[0]);
    }

    private static VmdpDeviceDirectPathState convertEnabledAndActiveToStateAndMessage(boolean enabled, boolean active, boolean isHostRebindWithoutRebootCapable) {
        VmdpDeviceStatus status = VmdpDeviceStatus.UNAVAILABLE;
        String statusMessage = HostStringUtil.getString("vmdpConfig.devStatus.unavailable", new String[0]);
        String directPathMessage = HostStringUtil.getString("vmdpConfig.status.isUnavailable.label", new String[0]);
        if (enabled && active) {
            statusMessage = HostStringUtil.getString("vmdpConfig.devStatus.available", new String[0]);
            directPathMessage = HostStringUtil.getString("vmdpConfig.status.isAvailable.label", new String[0]);
            status = VmdpDeviceStatus.AVAILABLE;
        }
        if (!isHostRebindWithoutRebootCapable) {
            if (enabled && !active) {
                statusMessage = HostStringUtil.getString("vmdpConfig.devStatus.availableLater", new String[0]);
                directPathMessage = HostStringUtil.getString("vmdpConfig.status.willBeAvailable.label", new String[0]);
                status = VmdpDeviceStatus.AVAILABLE_PENDING;
            }
            if (!enabled && active) {
                statusMessage = HostStringUtil.getString("vmdpConfig.devStatus.unavailableLater", new String[0]);
                directPathMessage = HostStringUtil.getString("vmdpConfig.status.willBeUnavailable.label", new String[0]);
                status = VmdpDeviceStatus.UNAVAILABLE_PENDING;
            }
        }
        return new VmdpDeviceDirectPathState(status, statusMessage, directPathMessage);
    }

    public static VmdpDeviceDirectPathState getVmdprDeviceInfoStatusAndMessage(boolean capable, boolean enabled, boolean active, boolean isHostRebindWithoutRebootCapable) {
        if (!capable) {
            return new VmdpDeviceDirectPathState(VmdpDeviceStatus.NOT_CONFIGURABLE, HostStringUtil.getString("vmdpConfig.devStatus.cantConfig", new String[0]), HostStringUtil.getString("vmdpConfig.status.notAble.label", new String[0]));
        }
        return VmdpDeviceInfoUtil.convertEnabledAndActiveToStateAndMessage(enabled, active, isHostRebindWithoutRebootCapable);
    }

    public static String getUnsignedShortAsHexString(short data) {
        int unsignedShort = data >= 0 ? data : 65536 + data;
        return Integer.toHexString(unsignedShort).toUpperCase();
    }

    public static String getUnsignedByteAsHexString(byte data) {
        int unsignedShort = data >= 0 ? data : 256 + data;
        return Integer.toHexString(unsignedShort).toUpperCase();
    }

    public static String getEsxDeviceInfo(StorageDeviceInfo storageDeviceInfo, NetworkInfo netInfo, String vmdpDeviceInfoId, String vmdpDeviceInfoClassId) {
        if (VmdpDeviceInfoUtil.isNetworkDevice(vmdpDeviceInfoClassId)) {
            return VmdpDeviceInfoUtil.findSwitchEsxDevice(netInfo, vmdpDeviceInfoId);
        }
        if (VmdpDeviceInfoUtil.isMassStorageController(vmdpDeviceInfoClassId)) {
            return VmdpDeviceInfoUtil.findHbEsxDeviceInfo(storageDeviceInfo, vmdpDeviceInfoId);
        }
        return null;
    }

    private static String findSwitchEsxDevice(NetworkInfo netInfo, String vmdpDeviceInfoId) {
        if (netInfo == null || vmdpDeviceInfoId == null) {
            return null;
        }
        PhysicalNic[] hostNics = netInfo.getPnic();
        VirtualSwitch[] vSwitches = netInfo.getVswitch();
        HostProxySwitch[] pSwitches = netInfo.getProxySwitch();
        String switchEsxDevice = null;
        for (PhysicalNic hostNic : hostNics) {
            if (!vmdpDeviceInfoId.equalsIgnoreCase(hostNic.getPci())) continue;
            if (vSwitches != null) {
                switchEsxDevice = VmdpDeviceInfoUtil.getVswitchEsxDeviceInfo(hostNic, vSwitches);
            }
            if (pSwitches == null || switchEsxDevice != null) break;
            switchEsxDevice = VmdpDeviceInfoUtil.getDvsEsxDeviceInfo(hostNic, pSwitches);
            break;
        }
        return switchEsxDevice;
    }

    private static String findHbEsxDeviceInfo(StorageDeviceInfo storageDeviceInfo, String vmdpDeviceInfoId) {
        HostBusAdapter[] hbas;
        if (storageDeviceInfo == null || vmdpDeviceInfoId == null) {
            return null;
        }
        for (HostBusAdapter hba : hbas = storageDeviceInfo.getHostBusAdapter()) {
            if (!vmdpDeviceInfoId.equals(hba.getPci())) continue;
            return hba.getDevice();
        }
        return null;
    }

    private static String getVswitchEsxDeviceInfo(PhysicalNic hostNic, VirtualSwitch[] vSwitches) {
        for (VirtualSwitch vSwitch : vSwitches) {
            String[] vSwicthPnics = vSwitch.getPnic();
            if (vSwicthPnics == null) continue;
            for (String vSwitchPnic : vSwicthPnics) {
                if (!hostNic.getKey().equals(vSwitchPnic)) continue;
                return HostStringUtil.getString("vmdpConfig.esxVirtualSwitchName.label", hostNic.getDevice(), vSwitch.getName());
            }
        }
        return null;
    }

    private static String getDvsEsxDeviceInfo(PhysicalNic hostNic, HostProxySwitch[] pSwitches) {
        for (HostProxySwitch pSwitch : pSwitches) {
            String[] pSwitchPnics = pSwitch.getPnic();
            if (pSwitchPnics == null) continue;
            for (String pSwitchPnic : pSwitchPnics) {
                if (!hostNic.getKey().equals(pSwitchPnic)) continue;
                return HostStringUtil.getString("vmdpConfig.esxDvsName.label", hostNic.getDevice(), pSwitch.getDvsName());
            }
        }
        return null;
    }

    private static boolean isNetworkDevice(String vmdpDeviceInfoClassId) {
        String[] networkDeviceIds = new String[]{"200", "201", "202", "203", "280"};
        return Arrays.asList(networkDeviceIds).contains(vmdpDeviceInfoClassId);
    }

    private static boolean isMassStorageController(String vmdpDeviceInfoClassId) {
        String[] storageDeviceIds = new String[]{"100", "101", "102", "103", "104", "180"};
        return Arrays.asList(storageDeviceIds).contains(vmdpDeviceInfoClassId);
    }

    static class VmdpDeviceDirectPathState {
        private String directPathStatusMessage;
        private String directPathStateMessage;
        private VmdpDeviceStatus status;

        VmdpDeviceDirectPathState(VmdpDeviceStatus status, String statusMessage, String stateMessage) {
            this.status = status;
            this.directPathStatusMessage = statusMessage;
            this.directPathStateMessage = stateMessage;
        }

        VmdpDeviceStatus getStatus() {
            return this.status;
        }

        String getDirectPathStatusMessage() {
            return this.directPathStatusMessage;
        }

        String getDirectPathStateMessage() {
            return this.directPathStateMessage;
        }
    }
}

