/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.capability;

import com.vmware.vim.binding.imagebuilder.Capabilities;
import com.vmware.vise.util.annotations.VisibleForTesting;
import com.vmware.vise.vim.commons.VcServiceHelper;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.capability.AutodeployCapability;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.ImageBuilderServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutodeployCapabilityImpl
implements AutodeployCapability {
    private static final Log _logger = LogFactory.getLog(AutodeployCapabilityImpl.class);
    @VisibleForTesting
    static VcServiceHelper vcServiceHelper = VcServiceHelper.getInstance();
    private final ImageBuilderServiceFactory _imageBuilderServiceFactory;
    private final AutoDeployServiceFactory _autoDeployServiceFactory;

    public AutodeployCapabilityImpl(ImageBuilderServiceFactory imageBuilderServiceFactory, AutoDeployServiceFactory autoDeployServiceFactory) {
        this._imageBuilderServiceFactory = imageBuilderServiceFactory;
        this._autoDeployServiceFactory = autoDeployServiceFactory;
    }

    @Override
    public com.vmware.vim.binding.rbd.Capabilities getAutodeployCapabilities(String vcGuid) {
        if (vcServiceHelper.is80VcOrLaterByServerGuid(vcGuid, true)) {
            AutoDeployService autoDeployService = this._autoDeployServiceFactory.getService(vcGuid);
            try {
                com.vmware.vim.binding.rbd.Capabilities rbdCapability = autoDeployService.getServiceInstance().getCapabilities();
                if (rbdCapability != null) {
                    return rbdCapability;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        _logger.warn((Object)String.format("%s not fetched, providing default values.", com.vmware.vim.binding.rbd.Capabilities.class.getName()));
        return new com.vmware.vim.binding.rbd.Capabilities();
    }

    @Override
    public Capabilities getImageBuilderCapabilities(String vcGuid) {
        if (vcServiceHelper.is80VcOrLaterByServerGuid(vcGuid, true)) {
            ImageBuilderService imageBuilderService = this._imageBuilderServiceFactory.getService(vcGuid);
            try {
                Capabilities imageBuilderCapability = imageBuilderService.getServiceInstance().getCapabilities();
                if (imageBuilderCapability != null) {
                    return imageBuilderCapability;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        _logger.warn((Object)String.format("%s not fetched, providing default values.", Capabilities.class.getName()));
        return new Capabilities();
    }
}

