/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.http.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.vmware.vim.binding.rbd.HostOps;
import com.vmware.vim.binding.rbd.Rule;
import com.vmware.vim.binding.rbd.RuleData;
import com.vmware.vim.binding.rbd.RuleSet;
import com.vmware.vim.binding.rbd.ServiceContent;
import com.vmware.vim.binding.rbd.fault.NoPermission;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vise.vim.commons.vmomi.response.ResultInterceptorImpl;

public class AutoDeployResultInterceptorImpl
extends ResultInterceptorImpl {
    private final String _serverGuidKey;

    public AutoDeployResultInterceptorImpl(String serverGuidKey) {
        this._serverGuidKey = (String)Preconditions.checkNotNull((Object)serverGuidKey);
    }

    /*
     * WARNING - void declaration
     */
    public Object handleReturnVal(Object returnVal, InvocationContext context) {
        int n;
        Rule.RuleSpec spec;
        Optional<String> serverGuidValue = this.getServerGuid(context);
        if (!serverGuidValue.isPresent()) {
            return super.handleReturnVal(returnVal, context);
        }
        String serverGuid = (String)serverGuidValue.get();
        if (returnVal instanceof ManagedObjectReference) {
            ManagedObjectReference moRef = (ManagedObjectReference)returnVal;
            moRef.setServerGuid(serverGuid);
        }
        if (returnVal instanceof ManagedObjectReference[]) {
            ManagedObjectReference[] moRefArray;
            for (ManagedObjectReference managedObjectReference : moRefArray = (ManagedObjectReference[])returnVal) {
                managedObjectReference.setServerGuid(serverGuid);
            }
        }
        if (returnVal instanceof ServiceContent) {
            ServiceContent content = (ServiceContent)returnVal;
            content.ruleManager.setServerGuid(serverGuid);
            content.pxeManager.setServerGuid(serverGuid);
            content.configManager.setServerGuid(serverGuid);
        }
        if (returnVal instanceof Rule.RuleSpec) {
            spec = (Rule.RuleSpec)returnVal;
            this.handleRuleSpec(spec, serverGuid);
        }
        if (returnVal instanceof RuleData[]) {
            void var9_13;
            RuleData[] ruleDataArray = (RuleData[])returnVal;
            RuleData[] ruleDataArray2 = ruleDataArray = (RuleData[])MoreObjects.firstNonNull((Object)ruleDataArray, (Object)new RuleData[0]);
            n = ruleDataArray2.length;
            boolean bl = false;
            while (var9_13 < n) {
                RuleData ruleData = ruleDataArray2[var9_13];
                ManagedObjectReference ruleRef = ruleData.rule;
                ruleRef.setServerGuid(serverGuid);
                this.handleRuleSpec(ruleData.getSpecObject(), serverGuid);
                ++var9_13;
            }
        }
        if (returnVal instanceof RuleSet.RuleSetSpec) {
            void var9_15;
            spec = (RuleSet.RuleSetSpec)returnVal;
            ManagedObjectReference[] moRefArray = spec.getRuleList();
            ManagedObjectReference[] managedObjectReferenceArray = moRefArray = (ManagedObjectReference[])MoreObjects.firstNonNull((Object)moRefArray, (Object)new ManagedObjectReference[0]);
            n = managedObjectReferenceArray.length;
            boolean bl = false;
            while (var9_15 < n) {
                ManagedObjectReference moRef2 = managedObjectReferenceArray[var9_15];
                moRef2.setServerGuid(serverGuid);
                ++var9_15;
            }
        }
        if (returnVal instanceof RuleSet.CheckResult[]) {
            RuleSet.CheckResult[] checkResults = (RuleSet.CheckResult[])returnVal;
            checkResults = (RuleSet.CheckResult[])MoreObjects.firstNonNull((Object)checkResults, (Object)new RuleSet.CheckResult[0]);
            this.handleCheckResults(checkResults, serverGuid);
        }
        if (returnVal instanceof HostOps.HostAssociation[]) {
            HostOps.HostAssociation[] associations = (HostOps.HostAssociation[])returnVal;
            associations = (HostOps.HostAssociation[])MoreObjects.firstNonNull((Object)associations, (Object)new HostOps.HostAssociation[0]);
            for (ManagedObjectReference managedObjectReference : associations) {
                if (managedObjectReference.hostMoref != null) {
                    managedObjectReference.hostMoref.setServerGuid(serverGuid);
                }
                if (managedObjectReference.associations == null) continue;
                for (ManagedObjectReference moref : managedObjectReference.associations) {
                    moref.setServerGuid(serverGuid);
                }
            }
        }
        if (returnVal instanceof RuleSet.BulkCheckResult[]) {
            RuleSet.BulkCheckResult[] bulkCheckResults = (RuleSet.BulkCheckResult[])returnVal;
            for (ManagedObjectReference managedObjectReference : bulkCheckResults) {
                if (managedObjectReference.host != null) {
                    managedObjectReference.host.setServerGuid(serverGuid);
                }
                if (managedObjectReference.checkResult == null) continue;
                this.handleCheckResults(managedObjectReference.checkResult, serverGuid);
            }
        }
        return super.handleReturnVal(returnVal, context);
    }

    private void handleCheckResults(RuleSet.CheckResult[] checkResults, String serverGuid) {
        for (RuleSet.CheckResult checkResult : checkResults) {
            ManagedObjectReference ref = checkResult.currentItem;
            if (ref != null) {
                ref.setServerGuid(serverGuid);
            }
            if ((ref = checkResult.expectedItem) == null) continue;
            ref.setServerGuid(serverGuid);
        }
    }

    private void handleRuleSpec(Rule.RuleSpec spec, String serverGuid) {
        ManagedObjectReference[] moRefArray = spec.getItemList();
        for (ManagedObjectReference moRef : moRefArray = (ManagedObjectReference[])MoreObjects.firstNonNull((Object)moRefArray, (Object)new ManagedObjectReference[0])) {
            moRef.setServerGuid(serverGuid);
        }
    }

    public Exception handleSoapFault(Exception fault, InvocationContext context) {
        ManagedObjectReference moRef;
        Optional<String> serverGuid = this.getServerGuid(context);
        if (!serverGuid.isPresent()) {
            return super.handleSoapFault(fault, context);
        }
        if (fault instanceof NoPermission && (moRef = ((NoPermission)fault).getObject()) != null) {
            moRef.setServerGuid((String)serverGuid.get());
        }
        return super.handleSoapFault(fault, context);
    }

    private Optional<String> getServerGuid(InvocationContext context) {
        Preconditions.checkNotNull((Object)context);
        Object serverGuidObject = context.getInvocationContextObject(this._serverGuidKey);
        String serverGuid = serverGuidObject != null ? serverGuidObject.toString() : null;
        return Optional.fromNullable((Object)serverGuid);
    }
}

