/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.CachingVmomiClientFactory;
import com.vmware.vsphere.client.h5.autodeploy.impl.AutoDeployServiceImpl;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;

public class AutoDeployServiceFactory {
    private static final String AUTODEPLOY_SERVICE_MAP = "com.vmware.vsphere.client.h5.autodeploy.connection.impl.AUTODEPLOY_SERVICE_MAP";
    private final CachingVmomiClientFactory _clientFactory;

    public AutoDeployServiceFactory(CachingVmomiClientFactory clientFactory) {
        this._clientFactory = (CachingVmomiClientFactory)Preconditions.checkNotNull((Object)clientFactory);
    }

    public AutoDeployService getService(String serverGuid) {
        Preconditions.checkNotNull((Object)serverGuid, (Object)"VC server GUID is null when retrieving AutoDeploy service.");
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        String clientId = SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession());
        return this.getService(vcService, clientId);
    }

    public AutoDeployService getService(VcService vcService, String clientId) {
        Client vmomiClient = this._clientFactory.getClient(vcService, clientId);
        String serviceKey = vcService.getServiceGuid();
        ConcurrentMap<String, AutoDeployService> autoDeployServiceCache = AutoDeployServiceFactory.getAutodeployServiceMap();
        AutoDeployServiceImpl service = null;
        Object serviceObj = autoDeployServiceCache.get(serviceKey);
        if (serviceObj instanceof AutoDeployServiceImpl) {
            service = (AutoDeployServiceImpl)serviceObj;
        }
        if (service == null || service.getClient() != vmomiClient) {
            autoDeployServiceCache.put(serviceKey, new AutoDeployServiceImpl(vmomiClient, vcService.getServiceGuid()));
        }
        return (AutoDeployService)autoDeployServiceCache.get(serviceKey);
    }

    private static ConcurrentMap<String, AutoDeployService> getAutodeployServiceMap() {
        ConcurrentMap serviceMap = (ConcurrentMap)SessionUtil.getData((String)AUTODEPLOY_SERVICE_MAP);
        if (serviceMap == null) {
            SessionUtil.setData((String)AUTODEPLOY_SERVICE_MAP, new ConcurrentHashMap());
            serviceMap = (ConcurrentMap)SessionUtil.getData((String)AUTODEPLOY_SERVICE_MAP);
        }
        return serviceMap;
    }
}

