/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.vmware.vim.binding.rbd.PxeProfile;
import com.vmware.vim.binding.rbd.PxeProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;

public class AutoDeployHostPropertyProviderAdapter
implements PropertyProviderAdapter {
    private final AutoDeployServiceFactory _autoDeployServiceFactory;
    private static final String ASSOCIATED_IMAGE_PROFILE = "associatedImageProfile";
    private static final String ASSOCIATED_IMAGE_PROFILE_NAME = "associatedImageProfileName";

    private static PropertyValue createPropertyValue(String propertyName, Object value, Object object) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = propertyName;
        propValue.value = value;
        propValue.resourceObject = object;
        return propValue;
    }

    private static TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = "HostSystem";
        typeInfo.properties = new String[]{ASSOCIATED_IMAGE_PROFILE, ASSOCIATED_IMAGE_PROFILE_NAME};
        return new TypeInfo[]{typeInfo};
    }

    public AutoDeployHostPropertyProviderAdapter(DataServiceExtensionRegistry registry, AutoDeployServiceFactory autoDeployServiceFactory) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, AutoDeployHostPropertyProviderAdapter.getProvidedTypeInfos());
        this._autoDeployServiceFactory = autoDeployServiceFactory;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Object[] objects;
        ResultSet result = new ResultSet();
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        HashMap<String, AutoDeployService> autoDeployServices = new HashMap<String, AutoDeployService>();
        AutoDeployService service = null;
        for (Object object : objects = propertyRequest.objects) {
            ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
            ManagedObjectReference hostRef = (ManagedObjectReference)object;
            String serverGuid = hostRef.getServerGuid();
            if (!autoDeployServices.containsKey(serverGuid)) {
                autoDeployServices.put(serverGuid, this._autoDeployServiceFactory.getService(serverGuid));
            }
            ManagedObjectReference pxeProfile = null;
            String pxeProfileName = "";
            for (PropertySpec spec : propertyRequest.properties) {
                service = (AutoDeployService)autoDeployServices.get(serverGuid);
                PxeProfileManager manager = service.getPxeProfileManager();
                ManagedObjectReference[] pxeProfiles = manager.findAssociatedProfile(hostRef);
                if (pxeProfiles != null && pxeProfiles.length > 0) {
                    pxeProfile = pxeProfiles[0];
                }
                for (String propertyName : spec.propertyNames) {
                    if (ASSOCIATED_IMAGE_PROFILE.equals(propertyName)) {
                        values.add(AutoDeployHostPropertyProviderAdapter.createPropertyValue(ASSOCIATED_IMAGE_PROFILE, pxeProfile, object));
                        continue;
                    }
                    if (!ASSOCIATED_IMAGE_PROFILE_NAME.equals(propertyName)) continue;
                    if (pxeProfile != null) {
                        PxeProfile profile = (PxeProfile)service.getManagedObject(pxeProfile);
                        pxeProfileName = profile.retrieveImageProfileName();
                    }
                    values.add(AutoDeployHostPropertyProviderAdapter.createPropertyValue(ASSOCIATED_IMAGE_PROFILE_NAME, pxeProfileName, object));
                }
            }
            ResultItem item = new ResultItem();
            item.resourceObject = object;
            item.properties = values.toArray(new PropertyValue[values.size()]);
            items.add(item);
        }
        result.items = items.toArray(new ResultItem[items.size()]);
        return result;
    }
}

