/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.CommonReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.DepotReferenceUtil;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public final class ImageProfileReferenceUtil {
    public static final String IMAGE_PROFILE_TYPE = "imagebuilder:ImageProfile";
    private static final int VC_GUID_SEGMENT_INDEX = 0;
    private static final int DEPOT_URL_SEGMENT_INDEX = 1;
    private static final int IMAGE_PROFILE_ID_SEGMENT_INDEX = 2;

    public static ManagedObjectReference getVcRef(URI ref) {
        assert (ref != null);
        String vcGuid = ImageProfileReferenceUtil.getVcGuid(ref);
        if (StringUtils.isEmpty((String)vcGuid)) {
            return null;
        }
        return ManagedObjectUtil.getRootFolder((String)vcGuid);
    }

    public static URI getDepotRef(URI ref) {
        assert (ref != null);
        String vcGuid = ImageProfileReferenceUtil.getVcGuid(ref);
        String depotUrl = ImageProfileReferenceUtil.getDepotUrl(ref);
        if (StringUtils.isEmpty((String)vcGuid) || StringUtils.isEmpty((String)depotUrl)) {
            return null;
        }
        return DepotReferenceUtil.createRef(vcGuid, depotUrl);
    }

    public static String getVcGuid(URI ref) {
        return CommonReferenceUtil.getIdSegmentDecoded(ref, 0);
    }

    public static String getDepotUrl(URI ref) {
        return CommonReferenceUtil.getIdSegmentDecodedAsUrl(ref, 1);
    }

    public static String getImageProfileId(URI ref) {
        return CommonReferenceUtil.getIdSegmentDecoded(ref, 2);
    }

    public static URI createRef(String vcGuid, String depotUrl, String imageProfileId) {
        assert (vcGuid != null);
        assert (depotUrl != null);
        assert (imageProfileId != null);
        String[] segments = new String[]{CommonReferenceUtil.encodeString(vcGuid), CommonReferenceUtil.encodeUrlString(depotUrl), CommonReferenceUtil.encodeString(imageProfileId)};
        return DefaultUriSchemeUtil.createUri((String)IMAGE_PROFILE_TYPE, (String[])segments);
    }
}

