/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.cluster.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.profile.ComplianceManager;
import com.vmware.vim.binding.vim.profile.ComplianceResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import com.vmware.vsphere.client.hostprofile.impl.I18nUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterProfilePropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ClusterProfilePropertyProvider.class);
    private static final String CLUSTER_HOST_PROP = "host";
    private static final String HOST_SYSTEM_TYPE = "HostSystem";
    private DataService _dataService;

    public ClusterProfilePropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="ClusterComputeResource")
    public ComplianceResult[] getComplianceResults(ManagedObjectReference clusterRef) throws Exception {
        try {
            Object[] props;
            if (clusterRef == null) {
                throw new IllegalArgumentException(I18nUtil.getLocalizedString("profile.error.invalidArguments"));
            }
            ServiceInstanceContent serviceContent = Util.getServiceInstanceContent(clusterRef);
            ManagedObjectReference managerRef = serviceContent.getComplianceManager();
            if (managerRef == null) {
                return null;
            }
            ComplianceManager manager = (ComplianceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
            ArrayList<ComplianceResult> result = new ArrayList<ComplianceResult>();
            ComplianceResult[] clusterResult = manager.queryComplianceStatus(new ManagedObjectReference[0], new ManagedObjectReference[]{clusterRef});
            if (clusterResult != null) {
                for (ComplianceResult complianceResult : clusterResult) {
                    result.add(complianceResult);
                }
            }
            if (!ArrayUtils.isEmpty((Object[])(props = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)clusterRef, (String)CLUSTER_HOST_PROP, (String)HOST_SYSTEM_TYPE, (String[])new String[]{"hostProfileCompliance"})))) {
                for (Object pv : props) {
                    result.add((ComplianceResult)((PropertyValue)pv).value);
                }
            }
            return result.toArray(new ComplianceResult[result.size()]);
        }
        catch (Exception e) {
            _logger.error((Object)e);
            throw e;
        }
    }

    @type(value="HostSystem,ClusterComputeResource")
    public ManagedObjectReference getAssociatedClusterProfile(ManagedObjectReference moRef) throws Exception {
        try {
            ManagedObjectReference parentRef;
            if (moRef == null) {
                throw new IllegalArgumentException(I18nUtil.getLocalizedString("profile.error.invalidArguments"));
            }
            ServiceInstanceContent serviceContent = Util.getServiceInstanceContent(moRef);
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, HostSystem.class) && ManagedObjectUtil.isOfType((ManagedObjectReference)(parentRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)moRef, (String)"parent")), ClusterComputeResource.class)) {
                return Util.findAssociatedClusterProfile(serviceContent, parentRef);
            }
            return Util.findAssociatedClusterProfile(serviceContent, moRef);
        }
        catch (Exception e) {
            _logger.error((Object)e);
            throw e;
        }
    }
}

