/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5.remediate.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.hostprofile.data.PreRemediationSpec;
import com.vmware.vsphere.client.hostprofile.data.RemediateHostConfigData;
import com.vmware.vsphere.client.hostprofile.data.RemediationSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationSetting;
import com.vmware.vsphere.client.hostprofile.data.h5.ReadHostCustomizationsSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.util.PrecheckRemediateHelper;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.util.RemediateData;
import java.util.ArrayList;
import java.util.List;

public class RemediateHostPropertyProvider
implements PropertyProviderBean {
    private static final String ASSOCIATED_HOST_PROFILLE_PROPERTY = "associatedHostProfile";
    private QueryService _queryService;
    private MutationService _mutationService;
    private PrecheckRemediateHelper _helper;

    public RemediateHostPropertyProvider(QueryService queryService, MutationService mutationService) {
        this._queryService = queryService;
        this._mutationService = mutationService;
        this._helper = new PrecheckRemediateHelper();
    }

    @type(value="HostSystem")
    public RemediateData getRemediatePreCheckedData(ManagedObjectReference hostRef) {
        ManagedObjectReference associatedProfile = this.getAssociatedProfile(hostRef);
        ArrayList<HostCustomizationSetting> hostCustomizations = this.getHostCustomization(hostRef, associatedProfile);
        RemediateHostConfigData preCheckValidationResults = this.getPreRemediationResult(hostRef, hostCustomizations);
        List preCheckedNodeTree = this._helper.createNodeTree(preCheckValidationResults);
        RemediationSpec remediationSpec = this._helper.getRemediationSpec(associatedProfile, hostCustomizations, preCheckValidationResults, hostRef);
        RemediateData remediateData = new RemediateData();
        remediateData.setRemediateTree(preCheckedNodeTree);
        remediateData.setRemediationSpec(remediationSpec);
        return remediateData;
    }

    private ArrayList<HostCustomizationSetting> getHostCustomization(ManagedObjectReference hostRef, ManagedObjectReference associatedProfile) {
        ReadHostCustomizationsSpec readHostCustomizationSpec = new ReadHostCustomizationsSpec();
        readHostCustomizationSpec.hostProfile = associatedProfile;
        readHostCustomizationSpec.isNewlyAssociatedProfile = false;
        OperationResult[] hostProfileCustomizationsOperationResult = this._mutationService.applyOnMultiEntity((Object[])new ManagedObjectReference[]{hostRef}, (Object)readHostCustomizationSpec);
        return (ArrayList)hostProfileCustomizationsOperationResult[0].result;
    }

    private RemediateHostConfigData getPreRemediationResult(ManagedObjectReference hostRef, Object hostCustomizations) {
        PreRemediationSpec preRemediationSpec = new PreRemediationSpec();
        preRemediationSpec.hostCustomizations = new Object[]{hostCustomizations};
        preRemediationSpec.hosts = new ManagedObjectReference[]{hostRef};
        ValidationResult preCheckValidationResults = this._mutationService.validate((Object)hostRef, (Object)preRemediationSpec);
        return ((RemediateHostConfigData[])preCheckValidationResults.result)[0];
    }

    private ManagedObjectReference getAssociatedProfile(ManagedObjectReference hostRef) {
        List associatedHostProfileResultSetItems;
        ResourceItem associatedHostProfileResourceItem;
        List associatedHostProfilePropertyValues;
        ResultSet associatedHostProfileResultSet = this._queryService.select(new String[]{ASSOCIATED_HOST_PROFILLE_PROPERTY}).from(new String[]{hostRef.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef).fetch();
        ManagedObjectReference associatedHostProfileMor = null;
        if (associatedHostProfileResultSet != null && associatedHostProfileResultSet.getItems() != null && (associatedHostProfilePropertyValues = (associatedHostProfileResourceItem = (ResourceItem)(associatedHostProfileResultSetItems = associatedHostProfileResultSet.getItems()).get(0)).getPropertyValues()) != null && associatedHostProfilePropertyValues.size() > 0) {
            associatedHostProfileMor = (ManagedObjectReference)associatedHostProfilePropertyValues.get(0);
        }
        return associatedHostProfileMor;
    }
}

