/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.h5.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.profile.host.AnswerFileStatusResult;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.hostprofile.data.h5.HostProfileData;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class H5HostProfilePropertyProvider {
    private final QueryService _queryService;

    public H5HostProfilePropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="ClusterComputeResource/rootFolderHostProfiles")
    public List<HostProfileData[]> getRootFolderHostProfiles(Collection<ManagedObjectReference> entities) throws Exception {
        return this.getHostProfilesDataForRootFolder(entities);
    }

    @PropertyProvider(value="HostProfile/hostProfileRootFolderHostProfiles")
    public List<HostProfileData[]> getHostProfileRootFolderHostProfiles(Collection<ManagedObjectReference> entities) throws Exception {
        return this.getHostProfilesDataForRootFolder(entities);
    }

    @PropertyProvider(value="HostSystem/answerFileValidationStateCheck")
    public boolean getAnswerFileValidationStateCheck(ManagedObjectReference object) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("Illegal input host managed object reference");
        }
        ProfileManager profileManager = HostProfileUtils.getProfileManager((String)object.getServerGuid());
        AnswerFileStatusResult[] answerFileStatusResults = profileManager.queryAnswerFileStatus(new ManagedObjectReference[]{object});
        if (answerFileStatusResults == null || answerFileStatusResults.length == 0) {
            return false;
        }
        return ProfileManager.AnswerFileStatus.invalid.name().equals(answerFileStatusResults[0].status);
    }

    private List<HostProfileData[]> getHostProfilesDataForRootFolder(Collection<ManagedObjectReference> entities) throws Exception {
        if (CollectionUtils.isEmpty(entities) || entities.size() > 1) {
            throw new IllegalArgumentException("Supply a single entity!");
        }
        ManagedObjectReference currentEntity = entities.iterator().next();
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", "name", "config.annotation"}).from(new String[]{HostProfile.class.getSimpleName()}).where("serverGuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)currentEntity.getServerGuid()).fetch();
        List res = resultSet.getItems();
        ArrayList<HostProfileData> hostProfileData = new ArrayList<HostProfileData>();
        for (ResourceItem item : res) {
            HostProfileData currentHostProfileData = new HostProfileData();
            currentHostProfileData.provider = item.get("@modelKey");
            currentHostProfileData.name = (String)item.get("name");
            currentHostProfileData.description = (String)item.get("config.annotation");
            if (HostProfile.class.getSimpleName().equals(currentEntity.getType())) {
                ManagedObjectReference provider = (ManagedObjectReference)currentHostProfileData.provider;
                if (currentEntity.equals((Object)provider)) continue;
                hostProfileData.add(currentHostProfileData);
                continue;
            }
            hostProfileData.add(currentHostProfileData);
        }
        return Collections.singletonList(hostProfileData.toArray(new HostProfileData[0]));
    }
}

