/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl.hostcustomizations;

import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.host.AnswerFile;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.hostprofile.data.DeferredHostSettingsSpec;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationIntermediateValidationResult;
import com.vmware.vsphere.client.hostprofile.impl.I18nUtil;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsSequenceService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.DeferredPolicyOptionData;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.DeferredPolicyOptionDataImpl;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCustomizationsBatchService {
    private static final Log logger = LogFactory.getLog(HostCustomizationsSequenceService.class);
    private final HostCustomizationsService service;

    public HostCustomizationsBatchService(HostCustomizationsService service) {
        this.service = service;
    }

    public HostCustomizationIntermediateValidationResult validateHostCustomizations(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap, PolicyMetadata[] policyMetadata) throws Exception {
        ProfileManager profileManager = HostProfileUtils.getProfileManager((String)profileRef.getServerGuid());
        HostApplyProfile applyProfile = this.service.getHostApplyProfile(profileRef, spec.isNewlyAssociatedProfile, spec.hostApplyProfileWrapper, policyMetadata);
        Object[] arraySpec = this.createHostToConfigSpecMap(deferredPolicyOptionParameterMap, true);
        if (ArrayUtils.isEmpty((Object[])arraySpec)) {
            return new HostCustomizationIntermediateValidationResult();
        }
        ProfileManager.AnswerFileValidationResultMap[] results = profileManager.validateHostCustomizations((ProfileManager.HostToConfigSpecMap[])arraySpec, applyProfile);
        return this.service.createValidationResult(results);
    }

    public OperationResult[] applyHostCustomizations(ManagedObjectReference profileRef, ManagedObjectReference[] forceValidationOnHosts, ManagedObjectReference[] skipValidationOnHosts, Object[] rows) throws Exception {
        ProfileManager profileManager = HostProfileUtils.getProfileManager((String)profileRef.getServerGuid());
        ProfileManager.HostToConfigSpecMap[] validatingHostToConfigSpecs = null;
        if (!ArrayUtils.isEmpty((Object[])forceValidationOnHosts)) {
            Map<ManagedObjectReference, String> hostEntityNameMap = this.service.createHostEntityNameMap(forceValidationOnHosts);
            Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptions = this.service.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
            validatingHostToConfigSpecs = this.createHostToConfigSpecMap(deferredPolicyOptions, true);
        }
        ProfileManager.HostToConfigSpecMap[] skipValidatingHostToConfigSpecs = null;
        if (!ArrayUtils.isEmpty((Object[])skipValidationOnHosts)) {
            Map<ManagedObjectReference, String> hostEntityNameMap = this.service.createHostEntityNameMap(skipValidationOnHosts);
            Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptions = this.service.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
            skipValidatingHostToConfigSpecs = this.createHostToConfigSpecMap(deferredPolicyOptions, false);
        }
        ProfileManager.HostToConfigSpecMap[] allHostToConfigSpecs = null;
        if (validatingHostToConfigSpecs != null && skipValidatingHostToConfigSpecs != null) {
            ArrayList allList = new ArrayList(validatingHostToConfigSpecs.length + skipValidatingHostToConfigSpecs.length);
            Collections.addAll(allList, validatingHostToConfigSpecs);
            Collections.addAll(allList, skipValidatingHostToConfigSpecs);
            allHostToConfigSpecs = allList.toArray(new ProfileManager.HostToConfigSpecMap[allList.size()]);
        }
        if (allHostToConfigSpecs == null && !ArrayUtils.isEmpty(validatingHostToConfigSpecs)) {
            allHostToConfigSpecs = validatingHostToConfigSpecs;
        }
        if (allHostToConfigSpecs == null && !ArrayUtils.isEmpty(skipValidatingHostToConfigSpecs)) {
            allHostToConfigSpecs = skipValidatingHostToConfigSpecs;
        }
        if (ArrayUtils.isEmpty(allHostToConfigSpecs)) {
            return new OperationResult[0];
        }
        OperationResult operationResult = new OperationResult();
        try {
            operationResult.task = profileManager.updateHostCustomizations(allHostToConfigSpecs);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception occurred during update of customization settings.", (Throwable)e);
            operationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return new OperationResult[]{operationResult};
    }

    private ProfileManager.HostToConfigSpecMap[] createHostToConfigSpecMap(Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionsMap, Boolean validating) {
        ArrayList<ProfileManager.HostToConfigSpecMap> specs = new ArrayList<ProfileManager.HostToConfigSpecMap>();
        for (Map.Entry<ManagedObjectReference, DeferredPolicyOptionParameter[]> entity : deferredPolicyOptionsMap.entrySet()) {
            ProfileManager.AnswerFileOptionsCreateSpec answerFileSpec = new ProfileManager.AnswerFileOptionsCreateSpec();
            answerFileSpec.userInput = entity.getValue();
            if (ArrayUtils.isEmpty((Object[])answerFileSpec.userInput)) continue;
            answerFileSpec.validating = validating;
            ProfileManager.HostToConfigSpecMap hostSpec = new ProfileManager.HostToConfigSpecMap();
            hostSpec.setHost(entity.getKey());
            hostSpec.setConfigSpec((ProfileManager.AnswerFileCreateSpec)answerFileSpec);
            specs.add(hostSpec);
        }
        return specs.toArray(new ProfileManager.HostToConfigSpecMap[0]);
    }

    public DeferredPolicyOptionData getDeferredHostSettings(ManagedObjectReference hostProfileRef, ManagedObjectReference[] hosts, boolean isNewlyAssociatedProfile, ProfileWrapper hostApplyProfileWrapper, PolicyMetadata[] policiesMetadata) throws Exception {
        HostApplyProfile applyProfile;
        ProfileManager profileManager;
        ArrayList<Exception> faults = new ArrayList<Exception>();
        try {
            profileManager = HostProfileUtils.getProfileManager((String)hostProfileRef.getServerGuid());
            applyProfile = this.service.getHostApplyProfile(hostProfileRef, isNewlyAssociatedProfile, hostApplyProfileWrapper, policiesMetadata);
        }
        catch (Exception e) {
            logger.error((Object)"Can not get host customizations of the hosts.", (Throwable)e);
            faults.add(new Exception(I18nUtil.getLocalizedString("error.getHostCustomizations")));
            throw e;
        }
        ProfileManager.StructuredCustomizations[] customizations = applyProfile != null ? profileManager.retrieveHostCustomizationsForProfile(hosts, applyProfile) : profileManager.retrieveHostCustomizations(hosts);
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> result = this.fillDeferredPolicyOptionParametersMap(customizations, faults);
        return new DeferredPolicyOptionDataImpl(result, faults);
    }

    DeferredPolicyOptionData getDeferredHostSettingsForHosts(ProfileManager profileManager, ManagedObjectReference[] hosts) throws Exception {
        ProfileManager.StructuredCustomizations[] customizations = profileManager.retrieveHostCustomizations(hosts);
        ArrayList<Exception> faults = new ArrayList<Exception>();
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> result = this.fillDeferredPolicyOptionParametersMap(customizations, faults);
        return new DeferredPolicyOptionDataImpl(result, faults);
    }

    private Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> fillDeferredPolicyOptionParametersMap(ProfileManager.StructuredCustomizations[] customizations, List<Exception> faults) {
        HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults = new HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]>();
        if (!ArrayUtils.isEmpty((Object[])customizations)) {
            for (ProfileManager.StructuredCustomizations customization : customizations) {
                Exception fault;
                AnswerFile answerFile = customization.getCustomizations();
                if (answerFile != null && answerFile.userInput != null) {
                    cachedResults.put(customization.getEntity(), answerFile.userInput);
                    continue;
                }
                if (!(customization instanceof ProfileManager.RetrieveCustomizationsResult) || (fault = ((ProfileManager.RetrieveCustomizationsResult)customization).getFault()) == null) continue;
                logger.error((Object)"Retrieved host customizations contains error: ", (Throwable)fault);
                faults.add(fault);
            }
        }
        return cachedResults;
    }
}

