/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.common;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ResultObject
extends ManagedObjectReference {
    private static final long serialVersionUID = 1L;
    private final ManagedObjectReference _sourceObject;
    private List<PropertyValue> _properties;
    private Map<String, PropertyValue> _propertiesByName;
    private boolean _propertiesDirty = false;

    private ResultObject(ManagedObjectReference moref) {
        super(moref.getType(), moref.getValue(), moref.getServerGuid());
        this._sourceObject = moref;
    }

    public static ResultObject newInstance(ManagedObjectReference moref) {
        Validate.notNull((Object)moref);
        ResultObject newInstance = new ResultObject(moref);
        return newInstance;
    }

    public ManagedObjectReference getSourceObject() {
        return this._sourceObject;
    }

    public List<PropertyValue> getProperties() {
        return this._properties;
    }

    public boolean hasProperties() {
        return this._properties != null && !this._properties.isEmpty();
    }

    public Object getPropertyValue(String prop) {
        PropertyValue pv;
        if (StringUtils.isEmpty((CharSequence)prop)) {
            throw new IllegalArgumentException("property name is null");
        }
        if (this._properties == null || this._properties.isEmpty()) {
            return null;
        }
        if (this._propertiesDirty) {
            this.updatePropertyMap();
        }
        if ((pv = this._propertiesByName.get(prop)) == null) {
            return null;
        }
        return pv.value;
    }

    public void add(PropertyValue ... objProperty) {
        if (objProperty == null) {
            throw new IllegalArgumentException("objProperty is null");
        }
        if (objProperty.length == 0) {
            return;
        }
        this._propertiesDirty = true;
        if (this._properties == null) {
            this._properties = new ArrayList<PropertyValue>();
        }
        Collections.addAll(this._properties, objProperty);
    }

    private void updatePropertyMap() {
        if (this._propertiesByName == null) {
            this._propertiesByName = new HashMap<String, PropertyValue>();
        }
        for (PropertyValue propertyValue : this._properties) {
            this._propertiesByName.put(propertyValue.propertyName, propertyValue);
        }
        this._propertiesDirty = false;
    }
}

