/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.common;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResourceItem;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.common.ResultObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchUtil {
    private static final Log _logger = LogFactory.getLog(SearchUtil.class);

    public static ResultSet createFilteredResultSet(List<? extends ManagedObjectReference> objects, Set<PropertyConstraint> propertyConstraints, QuerySpec query, DataService dataService) {
        Validate.notNull(propertyConstraints);
        Validate.notNull(objects);
        Validate.notNull((Object)dataService);
        if (objects.isEmpty()) {
            return ResultUtil.newEmptyResultSet();
        }
        Set<String> requestedProperties = SearchUtil.propertySet(query);
        if (propertyConstraints.isEmpty()) {
            return SearchUtil.createResultSet(objects, requestedProperties, query.resultSpec);
        }
        Set<String> filterProperties = SearchUtil.getFilterProperties(propertyConstraints);
        if (filterProperties.isEmpty()) {
            _logger.error((Object)"Failed to extract property names from property constraints.");
            return SearchUtil.createResultSet(objects, requestedProperties, query.resultSpec);
        }
        try {
            List<ResultObject> objectsWithProperties = SearchUtil.getProperties(filterProperties, objects, dataService);
            Iterator<ResultObject> it = objectsWithProperties.iterator();
            while (it.hasNext()) {
                if (SearchUtil.meetsAnyConstraint(it.next().getProperties(), propertyConstraints)) continue;
                it.remove();
            }
            return SearchUtil.createResultSet(objectsWithProperties, requestedProperties, query.resultSpec);
        }
        catch (Exception dataServiceException) {
            _logger.error((Object)("Exception occured getting " + filterProperties.size() + " properties for " + objects.size() + " objects"), (Throwable)dataServiceException);
            return ResultUtil.newErrorResultSet((Exception[])new Exception[]{dataServiceException});
        }
    }

    public static boolean isObjectCountQuery(ResultSpec resultSpec) {
        if (resultSpec == null || resultSpec.maxResultCount == null) {
            return false;
        }
        return resultSpec.maxResultCount == 0;
    }

    public static boolean isObjectCountQuery(QuerySpec query) {
        return SearchUtil.isObjectCountQuery(query.resultSpec);
    }

    public static ResultSet createResultSet(int count) {
        ResultSet results = new ResultSet();
        results.totalMatchedObjectCount = count;
        return results;
    }

    public static ResultSet createResultSet(List<? extends ManagedObjectReference> objects, Set<String> requestedProperties, ResultSpec resultSpec) {
        if (objects.isEmpty()) {
            return ResultUtil.newEmptyResultSet();
        }
        ResultSet resultSet = new ResultSet();
        resultSet.totalMatchedObjectCount = objects.size();
        if (SearchUtil.isObjectCountQuery(resultSpec)) {
            return resultSet;
        }
        resultSet.items = new ResultItem[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            ManagedObjectReference obj = objects.get(i);
            ResultItem result = new ResultItem();
            if (obj.getClass().equals(ManagedObjectReference.class)) {
                result.resourceObject = obj;
            } else if (obj instanceof ResultObject) {
                result.resourceObject = ((ResultObject)obj).getSourceObject();
                List<PropertyValue> properties = ((ResultObject)obj).getProperties();
                result.properties = SearchUtil.filterProperties(properties, requestedProperties);
            } else {
                result.resourceObject = ObjectUtil.shallowCopy((Object)obj, ManagedObjectReference.class);
            }
            resultSet.items[i] = result;
        }
        return resultSet;
    }

    public static PropertyValue[] filterProperties(List<PropertyValue> properties, Set<String> propertiesToKeep) {
        if (properties.isEmpty() && !propertiesToKeep.isEmpty()) {
            return null;
        }
        ArrayList<PropertyValue> filtered = new ArrayList<PropertyValue>();
        for (PropertyValue property : properties) {
            if (!propertiesToKeep.contains(property.propertyName)) continue;
            filtered.add(property);
        }
        return CollectionUtils.isEmpty(filtered) ? null : filtered.toArray(new PropertyValue[filtered.size()]);
    }

    public static <T> T filterRelatedObject(RelationalConstraint constraint, Class<T> relatedObjectType, String relatedResourceType) {
        Validate.notNull((Object)constraint);
        Validate.notNull(relatedObjectType);
        if (!(constraint.constraintOnRelatedObject instanceof ObjectIdentityConstraint)) {
            _logger.error((Object)("Relation must be constrained to a specific object by an ObjectIdentityConstraint. The constraint on the related entity is of an invalid type " + constraint.constraintOnRelatedObject.getClass().getName()));
            return null;
        }
        ObjectIdentityConstraint source = (ObjectIdentityConstraint)constraint.constraintOnRelatedObject;
        if (!relatedObjectType.isInstance(source.target)) {
            _logger.error((Object)("The related object must be of type " + relatedObjectType.getCanonicalName()));
            return null;
        }
        if (relatedResourceType != null && !relatedResourceType.equals(source.targetType)) {
            return null;
        }
        Object relationShipTarget = source.target;
        return (T)relationShipTarget;
    }

    public static <T> List<T> getElementsOfType(Class<T> type, Object[] items) {
        Validate.notNull(type);
        Validate.notNull((Object)items);
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < items.length; ++i) {
            if (!type.isInstance(items[i])) continue;
            result.add(type.cast(items[i]));
        }
        return result;
    }

    public static Set<String> getFilterProperties(Collection<PropertyConstraint> propertyConstraints) {
        Validate.notNull(propertyConstraints);
        if (propertyConstraints.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (PropertyConstraint pc : propertyConstraints) {
            if (StringUtils.isEmpty((CharSequence)pc.propertyName)) {
                _logger.warn((Object)"A property constraint contained an empty or null property name");
                continue;
            }
            result.add(pc.propertyName);
        }
        return result;
    }

    public static List<ResultObject> getProperties(Set<String> propertySet, Collection<? extends ManagedObjectReference> objects, DataService dataService) throws Exception {
        Validate.notNull(propertySet);
        Validate.notNull(objects);
        Validate.notNull((Object)dataService);
        if (propertySet.isEmpty()) {
            throw new IllegalArgumentException("Property set is empty");
        }
        if (objects.isEmpty()) {
            return Collections.emptyList();
        }
        String[] properties = propertySet.toArray(new String[propertySet.size()]);
        PropertyValue[] propertyValues = QueryUtil.getProperties((DataService)dataService, (Object[])objects.toArray(), (String[])properties);
        HashMap<ManagedObjectReference, ResultObject> result = new HashMap<ManagedObjectReference, ResultObject>();
        for (ManagedObjectReference managedObjectReference : objects) {
            ResultObject resultObj = managedObjectReference instanceof ResultObject ? (ResultObject)managedObjectReference : ResultObject.newInstance(managedObjectReference);
            result.put(managedObjectReference, resultObj);
        }
        for (PropertyValue value : propertyValues) {
            assert (value.resourceObject instanceof ManagedObjectReference);
            ManagedObjectReference provider = (ManagedObjectReference)value.resourceObject;
            assert (result.containsKey(provider));
            ((ResultObject)((Object)result.get(provider))).add(value);
        }
        return new ArrayList<ResultObject>(result.values());
    }

    public static ExtensionUriSpec getRelatedExtensionSpec(RelationalConstraint constraint) {
        URI relatedObject = SearchUtil.filterRelatedObject(constraint, URI.class, null);
        if (relatedObject == null) {
            return null;
        }
        String relatedResourceType = DefaultUriSchemeUtil.getType((URI)relatedObject);
        if (!"VcExtension".equals(relatedResourceType)) {
            return null;
        }
        return ExtensionUriSpec.fromDataServiceUri(relatedObject);
    }

    public static <T> Set<T> getSubConstraints(Constraint parentConstraint, Class<T> requiredSubConstraintType, String subConstraintTargetType, Conjoiner allowedComposite, boolean ignoreBaseCompositeConjoiner) {
        HashSet result = new HashSet();
        return SearchUtil.getSubConstraintsRecursively(parentConstraint, requiredSubConstraintType, subConstraintTargetType, allowedComposite, ignoreBaseCompositeConjoiner, result);
    }

    private static <T> Set<T> getSubConstraintsRecursively(Constraint constraint, Class<T> constraintType, String targetType, Conjoiner allowedComposite, boolean ignoreBaseCompositeConjoiner, Set<T> result) {
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint composite = (CompositeConstraint)constraint;
            if (composite.nestedConstraints == null) {
                return result;
            }
            if (composite.nestedConstraints.length == 1) {
                return SearchUtil.getSubConstraintsRecursively(composite.nestedConstraints[0], constraintType, targetType, allowedComposite, ignoreBaseCompositeConjoiner, result);
            }
            boolean conjoinerAllowed = allowedComposite == null || allowedComposite.equals((Object)composite.conjoiner);
            for (Constraint subConstraint : composite.nestedConstraints) {
                if (!conjoinerAllowed && (!ignoreBaseCompositeConjoiner || !(subConstraint instanceof CompositeConstraint))) continue;
                SearchUtil.getSubConstraintsRecursively(subConstraint, constraintType, targetType, allowedComposite, ignoreBaseCompositeConjoiner, result);
            }
        } else if (constraintType.isInstance(constraint) && (targetType == null && constraint.targetType == null || targetType.equals(constraint.targetType))) {
            Constraint resultItem = constraint;
            result.add(resultItem);
        }
        return result;
    }

    public static boolean isPropertyRequested(String propertyName, QuerySpec query) {
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            throw new IllegalArgumentException("propertyName is null or empty");
        }
        if (query == null || query.resourceSpec == null || ArrayUtils.isEmpty((Object[])query.resourceSpec.propertySpecs)) {
            return false;
        }
        for (PropertySpec propertySpec : query.resourceSpec.propertySpecs) {
            for (String name : propertySpec.propertyNames) {
                if (!propertyName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean meetsConstraint(Object value, PropertyConstraint constraint) {
        Validate.notNull((Object)constraint);
        if (constraint.comparator == Comparator.EQUALS) {
            return value == constraint.comparableValue || value != null && value.equals(constraint.comparableValue);
        }
        if (constraint.comparator == Comparator.NOT_EQUALS) {
            return value != constraint.comparableValue || value != null && !value.equals(constraint.comparableValue);
        }
        if (value == null) {
            return false;
        }
        if (value.getClass().equals(constraint.comparableValue.getClass()) && value instanceof Comparable && constraint.comparableValue instanceof Comparable && (constraint.comparator == Comparator.GREATER || constraint.comparator == Comparator.SMALLER)) {
            switch (constraint.comparator) {
                case SMALLER: {
                    return ObjectUtil.compare((Object)value, (Object)constraint.comparableValue) < 0;
                }
                case GREATER: {
                    return ObjectUtil.compare((Object)value, (Object)constraint.comparableValue) > 0;
                }
            }
        }
        if (value instanceof String && constraint.comparableValue instanceof String) {
            String stringConstraint = ((String)constraint.comparableValue).toLowerCase();
            String stringProperty = ((String)value).toLowerCase();
            switch (constraint.comparator) {
                case MATCHES: 
                case TEXTUALLY_MATCHES: {
                    if ("*".equals(stringConstraint)) {
                        return true;
                    }
                    return stringProperty.contains(stringConstraint);
                }
                case CONTAINS: {
                    return stringProperty.contains(stringConstraint);
                }
                case ENDS_WITH: {
                    return stringProperty.endsWith(stringConstraint);
                }
                case STARTS_WITH: {
                    return stringProperty.startsWith(stringConstraint);
                }
            }
        }
        _logger.warn((Object)("Search constraint comparator " + constraint.comparator + " not supported"));
        return false;
    }

    public static boolean meetsAnyConstraint(List<PropertyValue> properties, Collection<PropertyConstraint> constraints) {
        Validate.notNull(properties);
        Validate.notNull(constraints);
        if (constraints.isEmpty()) {
            return true;
        }
        HashMap<String, Object> propertyValuesByName = new HashMap<String, Object>();
        for (PropertyValue property : properties) {
            propertyValuesByName.put(property.propertyName, property.value);
        }
        boolean constraintExists = false;
        for (PropertyConstraint constraint : constraints) {
            if (constraint == null) continue;
            constraintExists = true;
            if (!propertyValuesByName.containsKey(constraint.propertyName) || !SearchUtil.meetsConstraint(propertyValuesByName.get(constraint.propertyName), constraint)) continue;
            return true;
        }
        return !constraintExists;
    }

    public static Set<String> propertySet(PropertySpec[] propertySet) {
        HashSet<String> result = new HashSet<String>();
        for (PropertySpec propertySpec : propertySet) {
            if (propertySpec == null || ArrayUtils.isEmpty((Object[])propertySpec.propertyNames)) continue;
            for (String property : propertySpec.propertyNames) {
                if (!StringUtils.isNotEmpty((CharSequence)property)) continue;
                result.add(property);
            }
        }
        return result;
    }

    public static Set<String> propertySet(QuerySpec query) {
        Validate.notNull((Object)query);
        if (query.resourceSpec == null || query.resourceSpec.propertySpecs == null) {
            return Collections.emptySet();
        }
        return SearchUtil.propertySet(query.resourceSpec.propertySpecs);
    }

    public static boolean queryHasOption(QuerySpec query, String name, Object value) {
        Validate.notNull((Object)query);
        Validate.notNull((Object)name);
        if (query.options == null || query.options.isEmpty()) {
            return false;
        }
        Object val = query.options.get(name);
        if (val == null) {
            return value == null;
        }
        return val.equals(value);
    }

    public static boolean isPropertyConstrained(Iterable<PropertyConstraint> constraints, String propertyName) {
        return SearchUtil.getPropertyConstraint(constraints, propertyName) != null;
    }

    public static PropertyConstraint getPropertyConstraint(Iterable<PropertyConstraint> constraints, String propertyName) {
        Validate.notNull(constraints);
        Validate.notNull((Object)propertyName);
        for (PropertyConstraint constraint : constraints) {
            if (!propertyName.equals(constraint.propertyName)) continue;
            return constraint;
        }
        return null;
    }

    public static void setResource(Collection<? extends ResourceItem> items, Object resource) {
        Validate.notNull(items);
        for (ResourceItem resourceItem : items) {
            resourceItem.resourceObject = resource;
        }
    }
}

