/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.admin.sddc.link;

import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.bindings.client.AsyncCallbackFuture;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.hlm.Community;
import com.vmware.vcenter.hlm.CommunityTypes;
import com.vmware.vcenter.hvc.Links;
import com.vmware.vcenter.hvc.LinksTypes;
import com.vmware.vcenter.hvc.management.Administrators;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.admin.sddc.link.model.LinkedDomainData;
import com.vmware.vsphere.client.admin.sddc.link.model.SddcMemberData;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SddcGroupPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(SddcGroupPropertyProvider.class);
    private Administrators _adminService;
    private final Community _hlmCommunityService;
    private final Links _hlmLinkService;
    private final LookupService _lookupService;
    private final VcSource _vcSource;

    public SddcGroupPropertyProvider(Community hlmCommunityService, Links hlmLinkService, LookupService lookupService, VcSource vcSource, Administrators adminService) {
        this._hlmCommunityService = hlmCommunityService;
        this._hlmLinkService = hlmLinkService;
        this._lookupService = lookupService;
        this._vcSource = vcSource;
        this._adminService = adminService;
    }

    @ModelMetadata(type={"*"}, property="vsphere:sddcs")
    public List<SddcMemberData> getSddcs(URI resourceUri) throws Exception {
        InvocationConfig invConfig = this.getInvocationConfig();
        AsyncCallbackFuture communityFuture = new AsyncCallbackFuture();
        this._hlmCommunityService.get((AsyncCallback)communityFuture, invConfig);
        AsyncCallbackFuture linksFuture = new AsyncCallbackFuture();
        this._hlmLinkService.list((AsyncCallback)linksFuture, invConfig);
        ArrayList<SddcMemberData> sddcGroupMembers = new ArrayList<SddcMemberData>();
        String localVcServiceUrl = this.findLocalServiceUrl();
        String localVcHostName = "";
        if (!localVcServiceUrl.isEmpty()) {
            URL url = new URL(localVcServiceUrl);
            localVcHostName = url.getHost();
            SddcMemberData sddcInstance = SddcMemberData.newSddcInstance(localVcHostName, true);
            sddcGroupMembers.add(sddcInstance);
        }
        try {
            List links = (List)linksFuture.get();
            for (LinksTypes.Summary link : links) {
                LinkedDomainData linkInstance = new LinkedDomainData();
                linkInstance.displayName = link.getDisplayName();
                linkInstance.link = link.getLink();
                List vcenterInfos = this._lookupService.getVcenterInfos(link.getLink());
                linkInstance.vcenterInfos = vcenterInfos.toArray(new LookupService.VcenterInfo[0]);
                sddcGroupMembers.add(SddcMemberData.newLinkInstance(false, linkInstance));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error while processing Linked Domains data. It will not be available!", (Throwable)e);
        }
        try {
            CommunityTypes.Info info = (CommunityTypes.Info)communityFuture.get();
            for (CommunityTypes.Member member : info.getMembers()) {
                if (member.getHostname().equals(localVcHostName)) continue;
                SddcMemberData sddcInstance = SddcMemberData.newSddcInstance(member.getHostname(), false);
                sddcGroupMembers.add(sddcInstance);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error while processing Multi SDDC data. It will not be available!", (Throwable)e);
        }
        return sddcGroupMembers;
    }

    @ModelMetadata(type={"*"}, property="vsphere:sddcCheck")
    public List<CommunityTypes.CheckInfo> getSddcGroupStatusCheck(URI resourceUri) throws Exception {
        return this._hlmCommunityService.check(null, this.getInvocationConfig());
    }

    @ModelMetadata(type={"*"}, property="vsphere:cloudAdmins")
    public Set<String> getCloudAdmins(URI resourceUri) throws Exception {
        return this._adminService.get(this.getInvocationConfig());
    }

    private InvocationConfig getInvocationConfig() {
        SsoDomain localDomain = SsoDomainHelper.getLocal();
        return VapiUtil.newInvocationConfig((SsoDomain)localDomain);
    }

    private String findLocalServiceUrl() {
        String localVCGuid = this._vcSource.getServiceIdOfLocalVc();
        List vcServerInfos = null;
        try {
            vcServerInfos = this._vcSource.getVcs();
        }
        catch (Exception e) {
            _logger.error((Object)"Could not retrieve any VC", (Throwable)e);
        }
        if (vcServerInfos == null || vcServerInfos.isEmpty()) {
            return "";
        }
        for (ServerInfoEx serverInfo : vcServerInfos) {
            if (!localVCGuid.equals(serverInfo.serviceGuid)) continue;
            return serverInfo.serviceUrl;
        }
        return ((ServerInfoEx)vcServerInfos.get((int)0)).serviceUrl;
    }
}

