/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cis.tasks;

import com.vmware.cis.Tasks;
import com.vmware.cis.task.Info;
import com.vmware.cis.task.Status;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.vim.tasks.TaskMonitorSpec;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.commonservice.util.Util;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VapiTaskMonitor {
    private static final Log _logger = LogFactory.getLog(VapiTaskMonitor.class);
    private final Tasks _taskService;

    public VapiTaskMonitor(Tasks taskService) {
        this._taskService = taskService;
    }

    public void monitorTask(String taskUid, TaskMonitorSpec spec, Consumer<Info> progressUpdateHandler) throws TimeoutException {
        Validate.notEmpty((String)taskUid);
        Objects.requireNonNull(spec);
        Objects.requireNonNull(progressUpdateHandler);
        this.monitorTaskCompletion(taskUid, spec, progressUpdateHandler);
    }

    private InvocationConfig getInvocationConfig() {
        SsoDomain localDomain = SsoDomainHelper.getLocal();
        return VapiUtil.newInvocationConfig((SsoDomain)localDomain);
    }

    private void monitorTaskCompletion(String taskUid, TaskMonitorSpec spec, Consumer<Info> progressUpdateHandler) throws TimeoutException {
        boolean taskCompleted = false;
        long timeoutBaseline = VapiTaskMonitor.currentTime();
        while (!taskCompleted) {
            Info taskInfo = this._taskService.get(taskUid, null, this.getInvocationConfig());
            taskCompleted = VapiTaskMonitor.isTaskCompleted(taskInfo);
            if (progressUpdateHandler != null) {
                try {
                    progressUpdateHandler.accept(taskInfo);
                }
                catch (Exception ex) {
                    _logger.error((Object)ex);
                }
            }
            if (taskCompleted) continue;
            VapiTaskMonitor.checkTimeout(timeoutBaseline, spec.timeoutInMillis);
            BlockingUtil.sleep((long)spec.intervalInMillis);
        }
    }

    private static boolean isTaskCompleted(Info taskInfo) {
        return taskInfo == null || taskInfo.getStatus() != null && EnumSet.of(Status.Values.SUCCEEDED, Status.Values.FAILED).contains(taskInfo.getStatus().getEnumValue());
    }

    private static void checkTimeout(long baseline, long timeoutMs) throws TimeoutException {
        if (timeoutMs < 0L) {
            return;
        }
        long passedMs = VapiTaskMonitor.currentTime() - baseline;
        if (passedMs > timeoutMs) {
            throw new TimeoutException(Util.getLocalizedString("cis.tasks.timeoutError"));
        }
    }

    static long currentTime() {
        return System.currentTimeMillis();
    }
}

