/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ProviderSummaryData;
import com.vmware.vsphere.client.commonservice.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;

@QueryBinding(value="ClusterComputeResource")
public final class ClusterSummaryData
extends ProviderSummaryData {
    private final String enabledLabel = Util.getLocalizedString("enabled");
    @Property(value="ClusterComputeResource/summary/numCpuCores")
    private short numProcessors;
    @Property(value="ClusterComputeResource/summary/numVmotions")
    private int numVMotionMigrations;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    private boolean drsEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/enabled")
    private boolean haEnabled;
    @Property(value="ClusterComputeResource/wcpEnabled")
    private boolean supervisorCluster;
    @Property(value="ClusterComputeResource/configurationEx/dpmConfigInfo/enabled")
    private boolean dpmEnabled;
    @Property(value="ClusterComputeResource/summary/currentEVCModeKey")
    private String evcStatus;
    @Property(value="ClusterComputeResource/configurationEx/vsanConfigInfo/enabled")
    private boolean vsanEnabled;
    @Property(value="ClusterComputeResource/isAttested")
    private boolean attested;
    @Relationship(value={"ClusterComputeResource/host"})
    @Property(value="HostSystem/config/vsanHostConfig/faultDomainInfo/name")
    private String[] vsanFaultDomains;
    @Property(value="ClusterComputeResource/isAutonomous")
    private boolean isAutonomous;
    @Property(value="ClusterComputeResource/summary/numHosts")
    private int hostsCount;
    @Property(value="ClusterComputeResource/virtualIP")
    private String autonomousClusterVirtualIP;

    protected long getStorageUnit() {
        return 0x100000L;
    }

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        BaseSummaryData.LabelValue[] summaryItemPairs = this.isAutonomous ? this.createAutonomousClusterItems() : this.createTraditionalClusterItems();
        return summaryItemPairs;
    }

    public BaseSummaryData.Badge[] getBadges() {
        ArrayList<BaseSummaryData.Badge> result = new ArrayList<BaseSummaryData.Badge>();
        if (this.drsEnabled || this.isAutonomous) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-distributedResourceScheduler24", "clusterSummaryFeatures.DRS", false));
        }
        if (this.haEnabled || this.isAutonomous) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-highAvailability24", "clusterSummaryFeatures.HA", false));
        }
        if (this.dpmEnabled) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-distributedPowerManagement24", "clusterSummaryFeatures.DPM", false));
        }
        if (this.supervisorCluster) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-supervisorCluster24", "clusterSummaryFeatures.SupervisorCluster", false));
        }
        if (this.attested) {
            result.add(new BaseSummaryData.Badge("host-ui-icon-hostAttested", "clusterSummaryFeatures.attested", false));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.evcStatus)) {
            result.add(new BaseSummaryData.Badge("icon-vSphere-evcEnabled24", "clusterSummaryFeatures.EVC", false));
        }
        return result.toArray(new BaseSummaryData.Badge[result.size()]);
    }

    void setvSanProperties(boolean enabled, String[] faultDomains) {
        this.vsanEnabled = enabled;
        this.vsanFaultDomains = faultDomains;
    }

    private BaseSummaryData.LabelValue[] createTraditionalClusterItems() {
        ArrayList<BaseSummaryData.LabelValue> itemPairs = new ArrayList<BaseSummaryData.LabelValue>();
        itemPairs.add(new BaseSummaryData.LabelValue("clusterSummaryProperties.NumProcessors", (Object)this.numProcessors));
        itemPairs.add(new BaseSummaryData.LabelValue("clusterSummaryProperties.NumVMotionMigrations", (Object)this.numVMotionMigrations));
        if (this.vsanEnabled && this.vsanFaultDomains != null && this.vsanFaultDomains.length > 0) {
            LinkedHashSet<String> fdSet = new LinkedHashSet<String>(Arrays.asList(this.vsanFaultDomains));
            HashSet<String> defaultDomain = new HashSet<String>(){
                {
                    this.add("");
                }
            };
            fdSet.removeAll(defaultDomain);
            String faultDomainValue = String.join((CharSequence)", ", fdSet);
            BaseSummaryData.LabelValue faultDomainItem = new BaseSummaryData.LabelValue("summaryView.faultDomains", (Object)faultDomainValue);
            itemPairs.add(faultDomainItem);
        }
        return itemPairs.toArray(new BaseSummaryData.LabelValue[0]);
    }

    private BaseSummaryData.LabelValue[] createAutonomousClusterItems() {
        ArrayList<BaseSummaryData.LabelValue> itemPairs = new ArrayList<BaseSummaryData.LabelValue>();
        itemPairs.add(new BaseSummaryData.LabelValue("clusterSummaryProperties.NumProcessors", (Object)this.numProcessors));
        itemPairs.add(new BaseSummaryData.LabelValue("autonomousClusterSummaryFeatures.autonomous", (Object)this.enabledLabel));
        itemPairs.add(new BaseSummaryData.LabelValue("autonomousClusterSummaryFeatures.vIP", (Object)this.autonomousClusterVirtualIP));
        itemPairs.add(new BaseSummaryData.LabelValue("autonomousClusterSummaryFeatures.username", (Object)"administrator@ccp.local"));
        itemPairs.add(new BaseSummaryData.LabelValue("autonomousClusterSummaryFeatures.hosts", (Object)this.hostsCount));
        return itemPairs.toArray(new BaseSummaryData.LabelValue[0]);
    }
}

