/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.commonservice.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QueryExecutorUtil {
    public static Object requestPropertyWithParam(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, Object mor, String propertyName, Object param) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(propertyName, param);
        Map<String, Object> propValues = QueryExecutorUtil.requestPropertiesWithParams(queryExecutor, querySpecBuilder, mor, new String[]{propertyName}, params);
        return propValues.get(propertyName);
    }

    public static Map<String, Object> requestPropertiesWithParams(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, Object mor, String[] propertyNames, Map<String, Object> propertyParams) throws Exception {
        QuerySpec querySpec = querySpecBuilder.buildQuerySpec(mor, propertyNames);
        for (PropertySpec propertySpec : querySpec.resourceSpec.propertySpecs) {
            if (propertySpec.propertyNames == null) continue;
            ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
            for (String propertyName : propertySpec.propertyNames) {
                if (!propertyParams.containsKey(propertyName)) continue;
                ParameterSpec paramSpec = new ParameterSpec();
                paramSpec.propertyName = propertyName;
                paramSpec.parameter = propertyParams.get(propertyName);
                parameterSpecs.add(paramSpec);
            }
            propertySpec.parameters = parameterSpecs.toArray(new ParameterSpec[parameterSpecs.size()]);
        }
        ResultSet resultSet = queryExecutor.getData(querySpec);
        if (resultSet != null && resultSet.items != null && resultSet.items.length > 0) {
            return QueryExecutorUtil.mapPropertyNamesToValues(resultSet.items[0].properties);
        }
        return new HashMap<String, Object>();
    }

    public static Object requestProperty(QueryExecutor queryExecutor, Object mor, String propertyName) throws Exception {
        return QueryExecutorUtil.requestProperties(queryExecutor, mor, new String[]{propertyName}).get(propertyName);
    }

    public static Map<String, Object> requestProperties(QueryExecutor queryExecutor, Object mor, String[] propertyNames) throws Exception {
        PropertyValue[] propertyValues = queryExecutor.getProperties(mor, propertyNames);
        return QueryExecutorUtil.mapPropertyNamesToValues(propertyValues);
    }

    public static Map<ManagedObjectReference, Object> requestPropertyForMultipleObjects(QueryExecutor queryExecutor, Object[] mors, String propertyName) throws Exception {
        return (Map)QueryExecutorUtil.requestPropertiesForMultipleObjects(queryExecutor, mors, new String[]{propertyName}).get(propertyName);
    }

    public static Map<String, Object> requestPropertiesForMultipleObjects(QueryExecutor queryExecutor, Object[] objects, String[] propertyNames) throws Exception {
        PropertyValue[] propertyValues = queryExecutor.getProperties(objects, propertyNames);
        return QueryExecutorUtil.mapPropertyNamesToMultipleValues(propertyValues);
    }

    public static Map<String, Object> mapPropertyNamesToValues(PropertyValue[] propertyValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (propertyValues != null) {
            for (PropertyValue propValue : propertyValues) {
                result.put(propValue.propertyName, propValue.value);
            }
        }
        return result;
    }

    public static Map<String, Object> mapPropertyNamesToMultipleValues(PropertyValue[] propertyValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (propertyValues != null) {
            for (PropertyValue property : propertyValues) {
                if (!result.containsKey(property.propertyName)) {
                    result.put(property.propertyName, new HashMap());
                }
                Map resultsPerValue = (Map)result.get(property.propertyName);
                resultsPerValue.put((ManagedObjectReference)property.resourceObject, property.value);
            }
        }
        return result;
    }
}

