/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.datastore.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreSubscriptionsFilterBuilder
implements QueryFilterBuilder {
    private final ObjectReferenceService _objectReferenceService;
    private static final Log _logger = LogFactory.getLog(DatastoreSubscriptionsFilterBuilder.class);

    public DatastoreSubscriptionsFilterBuilder(ObjectReferenceService objectReferenceService) {
        Validate.notNull((Object)objectReferenceService);
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="subscriptionDatastoreResourcePoolFilter")
    public Filter subscriptionDatastoreResourcePoolFilter(String datastoreId) {
        Validate.notNull((Object)datastoreId);
        Object datastoreRef = this._objectReferenceService.getReference(datastoreId, true);
        ArrayList<PropertyPredicate> criteria = new ArrayList<PropertyPredicate>();
        if (datastoreRef == null) {
            _logger.warn((Object)"Could not retrieve the datastore ref from the provided id");
            return new Filter(criteria);
        }
        criteria.add(new PropertyPredicate("computeResourceDatastore", PropertyPredicate.ComparisonOperator.EQUAL, datastoreRef));
        criteria.add(new PropertyPredicate("isRootRP", PropertyPredicate.ComparisonOperator.EQUAL, (Object)false));
        return new Filter(criteria);
    }

    @QueryFilter(value="subscriptionDatastoreClusterFilter")
    public Filter subscriptionDatastoreClusterFilter(String datastoreId) {
        Validate.notNull((Object)datastoreId);
        Object datastoreRef = this._objectReferenceService.getReference(datastoreId, true);
        ArrayList<PropertyPredicate> criteria = new ArrayList<PropertyPredicate>();
        if (datastoreRef == null) {
            _logger.warn((Object)"Could not retrieve the datastore ref from the provided id");
            return new Filter(criteria);
        }
        criteria.add(new PropertyPredicate("datastore", PropertyPredicate.ComparisonOperator.EQUAL, datastoreRef));
        return new Filter(criteria);
    }
}

