/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.folder.VmCountData;
import java.util.Collection;
import java.util.Collections;

public class FolderPropertyProvider {
    private static final String PROPERTY_INSTANCE_UUID = "@instanceUuid";
    private static final String IS_PRIMARY_OR_NORMAL_VM_PROPERTY = "isNormalVMOrPrimaryFTVM";
    private static final String VM_POWER_STATE_PROPERTY = "runtime.powerState";
    private QueryService _queryService;

    public FolderPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="Folder/vmCountData")
    public Collection<VmCountData> getVmCountData(Collection<ManagedObjectReference> objects) {
        if (objects == null || objects.size() != 1) {
            throw new IllegalArgumentException("getVmCountData accepts only a single  parameter.");
        }
        ManagedObjectReference vcRef = objects.iterator().next();
        String serverGuid = vcRef.getServerGuid();
        int poweredOnCount = this.getVmCount(VirtualMachine.PowerState.poweredOn, serverGuid);
        int poweredOffCount = this.getVmCount(VirtualMachine.PowerState.poweredOff, serverGuid);
        int suspendedCount = this.getVmCount(VirtualMachine.PowerState.suspended, serverGuid);
        return Collections.singleton(new VmCountData(poweredOnCount, poweredOffCount, suspendedCount));
    }

    private int getVmCount(VirtualMachine.PowerState powerState, String serverGuid) {
        ResultSet resultSet = this._queryService.select(new String[0]).from(new String[]{VirtualMachine.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate(PROPERTY_INSTANCE_UUID, PropertyPredicate.ComparisonOperator.EQUAL, (Object)serverGuid), new PropertyPredicate(IS_PRIMARY_OR_NORMAL_VM_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true), new PropertyPredicate(VM_POWER_STATE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)powerState)}).limit(0).withTotalCount().fetch();
        Integer totalCount = resultSet.getTotalCount();
        return totalCount != null ? totalCount : 0;
    }
}

