/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceMeterData;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;

@QueryBinding(value="Folder")
public final class StorageFolderSummaryData
extends BaseSummaryData
implements ResourceMeterData {
    @Property(value="Folder/allDs/length")
    private int datastoreCount;
    @Property(value="Folder/allSpod/length")
    private int dsClusterCount;
    @Relationship(value={"Folder/allDs"})
    @Property(value="Datastore/summary/capacity")
    private long[] storageCapacities;
    @Relationship(value={"Folder/allDs"})
    @Property(value="Datastore/info/freeSpace")
    private long[] storageFreeSpaces;

    public ResourceMeterData.ResourceMeter[] getResourceMeters() {
        long totalStorageCapacities = 0L;
        long totalFreeSpace = 0L;
        long totalUsedStorage = 0L;
        if (this.storageCapacities != null) {
            for (long storageCapacity : this.storageCapacities) {
                totalStorageCapacities += storageCapacity;
            }
        }
        if (this.storageFreeSpaces != null) {
            for (long storageFreeSpace : this.storageFreeSpaces) {
                totalFreeSpace += storageFreeSpace;
            }
        }
        totalUsedStorage = totalStorageCapacities - totalFreeSpace;
        String usedStorage = FormatUtil.getStorageFormatted((Long)Math.abs(totalUsedStorage), (long)1L, (long)-1L);
        String freeStorage = FormatUtil.getStorageFormatted((Long)totalFreeSpace, (long)1L, (long)-1L);
        String capacityStorage = FormatUtil.getStorageFormatted((Long)totalStorageCapacities, (long)1L, (long)-1L);
        return new ResourceMeterData.ResourceMeter[]{new ResourceMeterData.ResourceMeter("StorageResourceDataItem.StorageLabel", freeStorage, usedStorage, capacityStorage, ModulesApiUtil.getPercentageUsage((long)totalUsedStorage, (long)totalStorageCapacities))};
    }

    public BaseSummaryData.LabelValue[] getSummaryItems() {
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("summary.datastoreCount", (Object)this.datastoreCount), new BaseSummaryData.LabelValue("summary.dsClusterCount", (Object)this.dsClusterCount)};
    }
}

