/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.automatic.plugin.registration.commands.PluginRegistryCmd;
import com.vmware.automatic.plugin.registration.services.ConnectionService;
import com.vmware.automatic.plugin.registration.services.PluginExtensionRegistryService;
import com.vmware.vim25.Extension;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VimPortType;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class UpdatePluginCmd
extends PluginRegistryCmd {
    public UpdatePluginCmd(ConnectionService connectionService, PluginExtensionRegistryService registryService, CommandLineParser parser) {
        super(connectionService, registryService, parser);
    }

    @Override
    public Options getPluginOpts() {
        Options options = super.getPluginOpts();
        options.addOption(Option.builder("pu").longOpt("pluginUrl").hasArg().argName("plugin manifest url").required(false).desc("Url where the plugin manifest will be downloaded from.").build());
        options.addOption(Option.builder("v").longOpt("version").hasArg().argName("version").required(false).desc("Plugin version.").build());
        return options;
    }

    @Override
    protected void doExecute() throws Exception {
        ManagedObjectReference extensionManager;
        String key = this._commandLine.getOptionValue("k");
        String url = this._commandLine.getOptionValue("url");
        VimPortType vimPort = this.connectionService.getVimPort();
        Extension extension = vimPort.findExtension(extensionManager = this.connectionService.getExtensionManager(), key);
        if (extension == null) {
            throw new RuntimeException(String.format("Plugin '%s' is not registered with vCenter <%s>.", key, url));
        }
        this.registryService.updateTopLevelProperties(extension, this._commandLine);
        this.registryService.updateDescription(extension, this._commandLine);
        this.registryService.updateClientInfo(extension, this._commandLine);
        this.registryService.updateTaskList(extension, this._commandLine);
        this.registryService.updateFaultList(extension, this._commandLine);
        this.registryService.updatePrivilegeList(extension, this._commandLine);
        this.registryService.updateEventList(extension, this._commandLine);
        this.registryService.updateResourceInfo(extension, this._commandLine);
        this.registryService.updateServerInfo(extension, this._commandLine);
        this.registryService.updatelastHeartbeatTime(extension);
        vimPort.updateExtension(extensionManager, extension);
        System.out.println(String.format("Plugin '%s', registered to vCenter Server <%s>, has been successfully updated.", key, url));
    }
}

