/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.services;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vmware.vim25.Description;
import com.vmware.vim25.Extension;
import com.vmware.vim25.ExtensionClientInfo;
import com.vmware.vim25.ExtensionEventTypeInfo;
import com.vmware.vim25.ExtensionFaultTypeInfo;
import com.vmware.vim25.ExtensionPrivilegeInfo;
import com.vmware.vim25.ExtensionResourceInfo;
import com.vmware.vim25.ExtensionServerInfo;
import com.vmware.vim25.ExtensionTaskTypeInfo;
import com.vmware.vim25.KeyValue;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.cli.CommandLine;

public class PluginExtensionRegistryService {
    private static final String LOCAL_PLUGIN_TYPE = "vsphere-client-serenity";
    private static final String REMOTE_PLUGIN_TYPE = "vsphere-client-remote";
    private static final String HTTPS_PROTOCOL = "HTTPS";
    private static final String HTTP_PROTOCOL = "HTTP";
    private static final String MANIFEST_SERVER_TYPE = "MANIFEST_SERVER";
    private static final String DEFAULT_SERVER_TYPE = "PLUGIN_SERVER";
    private static final String ADMIN_EMAIL = "noreply@vmware.com";
    final Gson gson = new Gson();

    public void updateTopLevelProperties(Extension extension, CommandLine commandLine) {
        String version = commandLine.getOptionValue("v");
        String company = commandLine.getOptionValue("c");
        boolean showInSolutionManager = commandLine.hasOption("show");
        if (extension.getKey() == null) {
            extension.setKey(commandLine.getOptionValue("k"));
        }
        extension.setVersion(version != null ? version : extension.getVersion());
        extension.setCompany(company != null ? company : extension.getCompany());
        extension.setShownInSolutionManager(showInSolutionManager);
    }

    public void updateDescription(Extension extension, CommandLine commandLine) {
        Description description;
        String name = commandLine.getOptionValue("n");
        String summary = commandLine.getOptionValue("s");
        if (extension.getDescription() != null) {
            description = extension.getDescription();
        } else {
            description = new Description();
            description.setLabel("");
            description.setSummary("");
        }
        description.setLabel(name != null ? name : description.getLabel());
        description.setSummary(summary != null ? summary : description.getSummary());
        extension.setDescription(description);
    }

    public void updateClientInfo(Extension extension, CommandLine commandLine) {
        ExtensionClientInfo extClientInfo;
        String version = commandLine.getOptionValue("v");
        String company = commandLine.getOptionValue("c");
        String pluginUrl = commandLine.getOptionValue("pu");
        boolean isRemotePlugin = commandLine.hasOption("remote");
        if (extension.getClient().size() > 0) {
            extClientInfo = extension.getClient().get(0);
        } else {
            extClientInfo = new ExtensionClientInfo();
            extClientInfo.setCompany("");
        }
        extClientInfo.setVersion(version != null ? version : extClientInfo.getVersion());
        extClientInfo.setCompany(company != null ? company : extClientInfo.getCompany());
        extClientInfo.setDescription(extension.getDescription());
        extClientInfo.setType(isRemotePlugin ? REMOTE_PLUGIN_TYPE : LOCAL_PLUGIN_TYPE);
        extClientInfo.setUrl(pluginUrl != null ? pluginUrl : extClientInfo.getUrl());
        if (extension.getClient().size() == 0) {
            extension.getClient().add(extClientInfo);
        } else {
            extension.getClient().set(0, extClientInfo);
        }
    }

    public void updateTaskList(Extension extension, CommandLine commandLine) throws FileNotFoundException {
        String taskListFilePath = commandLine.getOptionValue("taskList");
        if (taskListFilePath == null) {
            return;
        }
        JsonObject[] taskInfos = this.gson.fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(taskListFilePath), StandardCharsets.UTF_8)), JsonObject[].class);
        ArrayList<ExtensionTaskTypeInfo> tempExtensionInfos = new ArrayList<ExtensionTaskTypeInfo>(taskInfos.length);
        for (JsonObject taskInfo : taskInfos) {
            ExtensionTaskTypeInfo extensionTaskInfo = new ExtensionTaskTypeInfo();
            JsonElement taskIdObj = taskInfo.get("taskId");
            if (taskIdObj == null) {
                throw new RuntimeException("Missing property 'taskId' in task object: " + this.gson.toJson(taskInfo));
            }
            extensionTaskInfo.setTaskID(taskIdObj.getAsString());
            tempExtensionInfos.add(extensionTaskInfo);
        }
        List<ExtensionTaskTypeInfo> extensionInfos = extension.getTaskList();
        extensionInfos.clear();
        extensionInfos.addAll(tempExtensionInfos);
    }

    public void updateFaultList(Extension extension, CommandLine commandLine) throws FileNotFoundException {
        String faultListFilePath = commandLine.getOptionValue("faultList");
        if (faultListFilePath == null) {
            return;
        }
        JsonObject[] faultInfos = this.gson.fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(faultListFilePath), StandardCharsets.UTF_8)), JsonObject[].class);
        ArrayList<ExtensionFaultTypeInfo> tempExtensionInfos = new ArrayList<ExtensionFaultTypeInfo>(faultInfos.length);
        for (JsonObject faultInfo : faultInfos) {
            ExtensionFaultTypeInfo extensionFaultInfo = new ExtensionFaultTypeInfo();
            JsonElement faultIdObj = faultInfo.get("faultId");
            if (faultIdObj == null) {
                throw new RuntimeException("Missing property 'faultId' in fault object: " + this.gson.toJson(faultInfo));
            }
            extensionFaultInfo.setFaultID(faultInfo.get("faultId").getAsString());
            tempExtensionInfos.add(extensionFaultInfo);
        }
        List<ExtensionFaultTypeInfo> extensionInfos = extension.getFaultList();
        extensionInfos.clear();
        extensionInfos.addAll(tempExtensionInfos);
    }

    public void updatePrivilegeList(Extension extension, CommandLine commandLine) throws FileNotFoundException {
        String privilegeListFilePath = commandLine.getOptionValue("privilegeList");
        if (privilegeListFilePath == null) {
            return;
        }
        JsonObject[] privilegeGroupInfos = this.gson.fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(privilegeListFilePath), StandardCharsets.UTF_8)), JsonObject[].class);
        ArrayList<ExtensionPrivilegeInfo> tempExtensionInfos = new ArrayList<ExtensionPrivilegeInfo>(privilegeGroupInfos.length);
        for (JsonObject privilegeGroupInfo : privilegeGroupInfos) {
            JsonArray privileges = privilegeGroupInfo.getAsJsonArray("privileges");
            if (privileges == null) {
                throw new RuntimeException("Missing property 'privileges' in privilege object: " + this.gson.toJson(privilegeGroupInfo));
            }
            JsonElement groupIdObj = privilegeGroupInfo.get("groupId");
            if (groupIdObj == null) {
                throw new RuntimeException("Missing property 'groupId' in privilege object: " + this.gson.toJson(privilegeGroupInfo));
            }
            String groupId = groupIdObj.getAsString();
            for (JsonElement privilegeInfo : privileges) {
                JsonElement privlegeIdObj = privilegeInfo.getAsJsonObject().get("privilegeId");
                if (privlegeIdObj == null) {
                    throw new RuntimeException("Missing property 'privilegeId' in privilege object: " + this.gson.toJson(privilegeGroupInfo));
                }
                ExtensionPrivilegeInfo extensionPrivilegeInfo = new ExtensionPrivilegeInfo();
                extensionPrivilegeInfo.setPrivGroupName(groupId);
                extensionPrivilegeInfo.setPrivID(groupId + "." + privlegeIdObj.getAsString());
                tempExtensionInfos.add(extensionPrivilegeInfo);
            }
        }
        List<ExtensionPrivilegeInfo> extensionInfos = extension.getPrivilegeList();
        extensionInfos.clear();
        extensionInfos.addAll(tempExtensionInfos);
    }

    public void updateEventList(Extension extension, CommandLine commandLine) throws FileNotFoundException {
        String eventListFilePath = commandLine.getOptionValue("eventList");
        if (eventListFilePath == null) {
            return;
        }
        JsonObject[] eventInfos = this.gson.fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(eventListFilePath), StandardCharsets.UTF_8)), JsonObject[].class);
        ArrayList<ExtensionEventTypeInfo> tempExtensionInfos = new ArrayList<ExtensionEventTypeInfo>(eventInfos.length);
        for (JsonObject eventInfo : eventInfos) {
            JsonElement eventIdObj = eventInfo.get("eventId");
            if (eventIdObj == null) {
                throw new RuntimeException("Missing property 'eventId' in event object: " + this.gson.toJson(eventInfo));
            }
            ExtensionEventTypeInfo extensionEventTypeInfo = new ExtensionEventTypeInfo();
            extensionEventTypeInfo.setEventID(eventIdObj.getAsString());
            JsonElement eventTypeSchemaObj = eventInfo.get("eventTypeSchema");
            if (eventTypeSchemaObj != null) {
                extensionEventTypeInfo.setEventTypeSchema(eventTypeSchemaObj.getAsString());
            }
            tempExtensionInfos.add(extensionEventTypeInfo);
        }
        List<ExtensionEventTypeInfo> extensionInfos = extension.getEventList();
        extensionInfos.clear();
        extensionInfos.addAll(tempExtensionInfos);
    }

    public void updateResourceInfo(Extension extension, CommandLine commandLine) throws FileNotFoundException {
        String taskListFilePath = commandLine.getOptionValue("resourceList");
        if (taskListFilePath == null) {
            return;
        }
        JsonObject resourceInfos = this.gson.fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(taskListFilePath), StandardCharsets.UTF_8)), JsonObject.class);
        ArrayList<ExtensionResourceInfo> tempExtensionInfos = new ArrayList<ExtensionResourceInfo>(resourceInfos.size());
        for (Map.Entry<String, JsonElement> resourcesByLocale : resourceInfos.entrySet()) {
            ExtensionResourceInfo extResourceInfo = new ExtensionResourceInfo();
            extResourceInfo.setLocale(resourcesByLocale.getKey());
            extResourceInfo.setModule("resources");
            for (Map.Entry<String, JsonElement> resource : resourcesByLocale.getValue().getAsJsonObject().entrySet()) {
                KeyValue kvPair = new KeyValue();
                kvPair.setKey(resource.getKey());
                kvPair.setValue(resource.getValue().getAsString());
                extResourceInfo.getData().add(kvPair);
            }
            tempExtensionInfos.add(extResourceInfo);
        }
        List<ExtensionResourceInfo> extensionInfos = extension.getResourceList();
        extensionInfos.clear();
        extensionInfos.addAll(tempExtensionInfos);
    }

    public void updateServerInfo(Extension extension, CommandLine commandLine) {
        ExtensionServerInfo manifestServerInfo;
        List<ExtensionServerInfo> servers;
        String pluginUrl = commandLine.getOptionValue("pu");
        String serverThumbprint = commandLine.getOptionValue("st");
        String company = commandLine.getOptionValue("c");
        String additionalPluginServers = commandLine.getOptionValue("ps");
        ServerInfo[] serverInfos = null;
        if (additionalPluginServers != null) {
            serverInfos = this.gson.fromJson(additionalPluginServers, ServerInfo[].class);
        }
        if (this.isPluginUrlHttp(pluginUrl)) {
            System.out.println("INFO: Not using https for your plugin URL is OK for testing but not recommended for production.\nUsers will have to include the flag allowHttp=true in their vSphere Client webclient.properties otherwise the http URL will be ignored");
        }
        if (!(servers = extension.getServer()).isEmpty()) {
            manifestServerInfo = servers.get(0);
        } else {
            manifestServerInfo = new ExtensionServerInfo();
            manifestServerInfo.getAdminEmail().add(ADMIN_EMAIL);
            manifestServerInfo.setCompany("");
        }
        manifestServerInfo.setType(MANIFEST_SERVER_TYPE);
        manifestServerInfo.setDescription(extension.getDescription());
        manifestServerInfo.setServerThumbprint(serverThumbprint != null ? serverThumbprint : manifestServerInfo.getServerThumbprint());
        manifestServerInfo.setUrl(pluginUrl != null ? pluginUrl : manifestServerInfo.getUrl());
        manifestServerInfo.setCompany(company != null ? company : manifestServerInfo.getCompany());
        ArrayList<ExtensionServerInfo> previousServerInfos = new ArrayList<ExtensionServerInfo>(servers);
        servers.clear();
        servers.add(manifestServerInfo);
        if (serverInfos == null || serverInfos.length == 0) {
            for (int i = 1; i < previousServerInfos.size(); ++i) {
                servers.add((ExtensionServerInfo)previousServerInfos.get(i));
            }
            return;
        }
        for (ServerInfo serverInfo : serverInfos) {
            ExtensionServerInfo esi = new ExtensionServerInfo();
            if (serverInfo.url == null) {
                throw new IllegalArgumentException("No URL was specified for a server info.");
            }
            if (!this.isPluginUrlHttp(serverInfo.url) && !this.isPluginUrlHttps(serverInfo.url)) {
                throw new IllegalArgumentException(String.format("Invalid protocol specified for server info url %s. Only http/https are supported.", serverInfo.url));
            }
            esi.setUrl(serverInfo.url);
            esi.setServerThumbprint(serverInfo.serverThumbprint);
            esi.setType(serverInfo.type != null ? serverInfo.type : DEFAULT_SERVER_TYPE);
            Description description = new Description();
            description.setLabel(serverInfo.label != null ? serverInfo.label : "");
            description.setSummary(serverInfo.summary != null ? serverInfo.summary : "");
            esi.setDescription(description);
            esi.setCompany(serverInfo.company != null ? serverInfo.company : "");
            esi.getAdminEmail().add(serverInfo.adminEmail != null ? serverInfo.adminEmail : ADMIN_EMAIL);
            servers.add(esi);
        }
    }

    public void updatelastHeartbeatTime(Extension extension) throws DatatypeConfigurationException {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar xmlCalendar = dtFactory.newXMLGregorianCalendar(cal);
        extension.setLastHeartbeatTime(xmlCalendar);
    }

    private boolean isPluginUrlHttps(String pluginUrl) {
        return pluginUrl != null && pluginUrl.toLowerCase().startsWith(HTTPS_PROTOCOL.toLowerCase());
    }

    private boolean isPluginUrlHttp(String pluginUrl) {
        return pluginUrl != null && pluginUrl.toLowerCase().startsWith(HTTP_PROTOCOL.toLowerCase().concat("://"));
    }

    private static class ServerInfo {
        public String url;
        public String type;
        public String serverThumbprint;
        public String label;
        public String summary;
        public String company;
        public String adminEmail;

        private ServerInfo() {
        }
    }
}

