/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.content.library.Item;
import com.vmware.content.library.ItemModel;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vcenter.ovf.ExportSession;
import com.vmware.vcenter.ovf.ExportSessionTypes;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.provisioning.spec.AddToLibrarySpec;
import com.vmware.vsphere.client.vapi.tasks.VapiAsyncCallback;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProvisioningContentLibraryMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ProvisioningContentLibraryMutationProvider.class);
    private static final long DOWNLOAD_SESSION_READY_TIMEOUT = 60000L;
    private static final long EXPORT_SESSION_STATE_POLL_INTERVAL = 2000L;
    private final ExportSession _exportSession;
    private final Item _libraryItemService;
    private VapiTaskMonitor _vapiTaskMonitor;

    public ProvisioningContentLibraryMutationProvider(ExportSession exportSession, Item libraryItemService) {
        this._exportSession = exportSession;
        this._libraryItemService = libraryItemService;
    }

    public void setVapiTaskMonitor(VapiTaskMonitor vapiTaskMonitor) {
        this._vapiTaskMonitor = vapiTaskMonitor;
    }

    public OperationResult apply(ManagedObjectReference objRef, AddToLibrarySpec spec) {
        String libraryNodeUuid;
        OperationResult result = new OperationResult();
        assert (objRef != null);
        assert (spec != null);
        assert (spec.contentLibrary != null);
        assert (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualMachine.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualApp.class));
        if (this.isUriEmpty(spec.libraryItem)) {
            result.entity = spec.contentLibrary;
            libraryNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)spec.contentLibrary);
        } else {
            result.entity = spec.libraryItem;
            libraryNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)spec.libraryItem);
            this.editLibraryItemDetails(spec);
        }
        ExportSessionTypes.SourceInfo sourceInfo = new ExportSessionTypes.SourceInfo();
        String objId = CisIdConverter.toGlobalCisId((ManagedObjectReference)objRef, (String)objRef.getServerGuid());
        Boolean isVmReference = ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualMachine.class);
        if (isVmReference.booleanValue()) {
            sourceInfo.setVmId(objId);
        } else {
            sourceInfo.setVappId(objId);
        }
        ExportSessionTypes.CreateSpec exportParameters = this.createAddToLibraryExportParamsSpec(spec);
        try {
            VapiAsyncCallback asyncCallback = new VapiAsyncCallback(this._vapiTaskMonitor, libraryNodeUuid);
            _logger.info((Object)String.format("Initiating export session for object: %s. Client token: %s", objId, asyncCallback.getActivationId()));
            this._exportSession.create(asyncCallback.getActivationId(), sourceInfo, (Structure)exportParameters, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
            _logger.info((Object)("Create export session task: " + ObjectUtil.prettyPrint((Object)result.task)));
        }
        catch (Exception e) {
            _logger.error((Object)("Could not create export session. spec =  " + ObjectUtil.prettyPrint((Object)spec)), (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    private void editLibraryItemDetails(AddToLibrarySpec spec) {
        String libraryItemId = VapiUriSchemeUtil.getId((URI)spec.libraryItem);
        String libraryItemNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)spec.libraryItem);
        ItemModel libraryItem = new ItemModel();
        if (StringUtils.isNotEmpty((CharSequence)spec.name)) {
            libraryItem.setName(spec.name);
        }
        if (spec.description != null) {
            libraryItem.setDescription(spec.description);
        }
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(this._vapiTaskMonitor, libraryItemNodeUuid);
        _logger.info((Object)("Initiating update library item. Client token: " + asyncCallback.getActivationId()));
        try {
            this._libraryItemService.update(libraryItemId, libraryItem, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Edit library item operation failed", (Throwable)e);
        }
    }

    private ExportSessionTypes.CreateSpec createAddToLibraryExportParamsSpec(AddToLibrarySpec spec) {
        ExportSessionTypes.CreateSpec createItemSpec = new ExportSessionTypes.CreateSpec();
        if (!this.isUriEmpty(spec.contentLibrary)) {
            createItemSpec.setContentLibrary(VapiUriSchemeUtil.getId((URI)spec.contentLibrary));
        }
        if (!this.isUriEmpty(spec.libraryItem)) {
            createItemSpec.setContentLibraryItem(VapiUriSchemeUtil.getId((URI)spec.libraryItem));
        }
        createItemSpec.setName(spec.name);
        createItemSpec.setDescription(spec.description);
        createItemSpec.setTargetType(ExportSessionTypes.TargetType.CONTENT_LIBRARY_TARGET);
        List<Object> exportFlags = new ArrayList();
        if (spec.exportFlags != null && spec.exportFlags.length > 0) {
            exportFlags = Arrays.asList(spec.exportFlags);
        }
        createItemSpec.setExportFlags(exportFlags);
        return createItemSpec;
    }

    private boolean isUriEmpty(URI uri) {
        return uri == null || uri.toString().length() == 0;
    }
}

