/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.file;

import com.vmware.h5.sdk.plugin.migration.config.Configuration;
import com.vmware.h5.sdk.plugin.migration.file.CustomStringWriter;
import com.vmware.h5.sdk.plugin.migration.serialize.PluginDataSerializer;
import com.vmware.vise.plugin.manifest.model.PluginData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class PluginConfigFileWriter {
    private static final String SYSTEM_MESSAGE_FORMAT = "[%s] %s";
    private Configuration configuration;
    private File reportFile;
    private Transformer transformer;

    public PluginConfigFileWriter(Configuration configuration) {
        this.configuration = configuration;
        this.initializePaths();
        this.initializeTransformerForPrint();
    }

    public void serializePluginData(PluginData pluginData) {
        PluginDataSerializer pluginDataDeserializer = new PluginDataSerializer(this.configuration);
        pluginDataDeserializer.serialize(pluginData);
    }

    public void logError(String message) {
        this.logMessage(String.format(SYSTEM_MESSAGE_FORMAT, "ERROR", message));
    }

    public void logWarning(String message) {
        this.logMessage(String.format(SYSTEM_MESSAGE_FORMAT, "WARN", message));
    }

    public void logError(Element element) {
        this.logError(this.getString(element));
    }

    public void logWarning(Element element) {
        this.logWarning(this.getString(element));
    }

    public void logMessage(Element element) {
        this.logMessage(this.getString(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(String message) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.reportFile, true));
            bufferedWriter.write(message);
            bufferedWriter.newLine();
            this.close(bufferedWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close(bufferedWriter);
        }
    }

    private String getString(Element element) {
        CustomStringWriter writer = new CustomStringWriter();
        try {
            StreamResult streamResult = new StreamResult(writer);
            this.transformer.transform(new DOMSource(element), streamResult);
        }
        catch (TransformerException ex) {
            System.out.println("Unable to transform xml element");
        }
        return ((StringWriter)writer).toString();
    }

    private void initializeTransformerForPrint() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.transformer = transformerFactory.newTransformer();
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerConfigurationException ex) {
            System.out.println(String.format("Unable to get xml transformer for transforming xml to string %s", ex.getMessage()));
            System.exit(1);
        }
    }

    private void close(BufferedWriter bufferedWriter) {
        try {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        catch (IOException e) {
            System.out.println(String.format("Error closing file reader %s", e.getMessage()));
        }
    }

    private void initializePaths() {
        Path reportFilePath = Paths.get(this.configuration.getOutputDir(), "report.txt");
        this.reportFile = reportFilePath.toFile();
        this.emptyFile(this.reportFile);
    }

    private void emptyFile(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.write("");
            printWriter.close();
        }
        catch (FileNotFoundException ex) {
            System.out.println(String.format("Not able to write to the file - %s", file.getAbsolutePath()));
        }
    }
}

