/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Document getDocumentForFile(File file) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        return dBuilder.parse(file);
    }

    public static List<Element> getChildElements(Element parentNode, String childElementName) {
        NodeList childNodes = parentNode.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals(childElementName)) continue;
            children.add((Element)childNode);
        }
        return children;
    }

    public static Map<String, List<Element>> getExtensionPointNameToChildExtensionElementsMap(Element parentNode) {
        NodeList childNodes = parentNode.getChildNodes();
        HashMap<String, List<Element>> map = new HashMap<String, List<Element>>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("extension")) continue;
            Element childElement = (Element)childNode;
            List<Element> extendedPointElements = XmlUtils.getChildElements(childElement, "extendedPoint");
            for (Element el : extendedPointElements) {
                String extendedPoint = el.getFirstChild().getNodeValue();
                map.computeIfAbsent(extendedPoint, ep -> new ArrayList()).add(childElement);
            }
        }
        return map;
    }

    public static Map<String, List<Element>> getTemplateInstancesGroupedByNamespace(Element parentNode) {
        NodeList childNodes = parentNode.getChildNodes();
        HashMap<String, List<Element>> map = new HashMap<String, List<Element>>();
        block0: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("templateInstance")) continue;
            NodeList templateInstanceChildNodes = childNode.getChildNodes();
            for (int j = 0; j < templateInstanceChildNodes.getLength(); ++j) {
                Node templateInstanceChildNode = templateInstanceChildNodes.item(j);
                if (!templateInstanceChildNode.getNodeName().equals("variable")) continue;
                String name = XmlUtils.getAttributeValue((Element)templateInstanceChildNode, "name");
                String value = XmlUtils.getAttributeValue((Element)templateInstanceChildNode, "value");
                if (!"namespace".equals(name)) continue;
                map.computeIfAbsent(value, ep -> new ArrayList()).add((Element)childNode);
                continue block0;
            }
        }
        return map;
    }

    public static Element getChildElement(Element parentNode, String childElementName) {
        NodeList childNodes = parentNode.getChildNodes();
        Element childElement = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals(childElementName)) continue;
            childElement = (Element)childNode;
            break;
        }
        return childElement;
    }

    public static String getChildElementNodeValue(Element parentNode, String childNodeName) {
        NodeList nodeList = parentNode.getElementsByTagName(childNodeName);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getFirstChild().getNodeValue();
        }
        return "";
    }

    public static String getLastChildElementNodeValue(Element parentNode, String ... childNodeNames) {
        Element node = XmlUtils.getLastChildElementNode(parentNode, childNodeNames);
        if (node != null) {
            return node.getFirstChild().getNodeValue();
        }
        return "";
    }

    public static Element getLastChildElementNode(Element parentNode, String ... childNodeNames) {
        int i = 0;
        Element node = parentNode;
        while (i < childNodeNames.length && node != null) {
            node = XmlUtils.getChildElement(node, childNodeNames[i++]);
        }
        return node;
    }

    public static String getAttributeValue(Element node, String attributeName) {
        return node.getAttribute(attributeName);
    }
}

